import React, { Component } from 'react';
import { Form, Input, Button, Select } from 'amos-framework';
import PropTypes from 'prop-types';
import { TreeSelect } from 'amos-antd';
import { queryAllRouteAction, queryCatalogTreeAction } from '../../../services/checkService';

const FormItem = Form.Item;

const Option = Select.Option;

/**
 * 巡检点查询
 *
 * @class InputItemSearch
 * @extends {Component}
 */
class PointSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        pointNo: {
          name: 'pointNo',
          type: 'LIKE',
          value: ''
        },
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        isFixed: {
          name: 'isFixed',
          value: ''
        },
        catalogId: {
          name: 'catalogId',
          value: ''
        }
      },
      catalogData: []
    };
  }

  componentWillMount() {
    // 查询分类目录
    this.queryCatalogTree();
    // 查询路线
    // this.queryAllRoute();
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  };

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  };

  // 暂未使用
  onRouteSelectChange = key => {
    const { form, routeData } = this.state;
    let routeNameList = [];
    form.routeId.value = key;
    for (let i = 0; i < key.length; i++) {
      for (let j = 0; j < routeData.length; j++) {
        if (routeData[j].id === key[i]) {
          routeNameList.push(routeData[j].name);
        }
      }
    }
    form.routeName.value = routeNameList;
    this.setState({ form });
  };

  queryCatalogTree = () => {
    queryCatalogTreeAction().then(data => {
      this.setState({ catalogData: data });
    });
  };

  queryAllRoute() {
    queryAllRouteAction().then(data => {
      this.setState({
        routeData: data
      });
    });
  }

  handleSubmit = e => {
    const { form } = this.state;
    const pageParam = { pageNumber: 0, pageSize: 10 };
    this.props.search(form, pageParam);
  };

  render() {
    const { form, catalogData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ width: 270, padding: '30px 0 0 0px' }} className="point-search" model={form}>
        <FormItem label={<span>编号</span>} field="pointNo" {...formItemLayout}>
          <Input prefixCls="" value={form.pointNo.value} className="search_Input" onChange={e => this.onChange('pointNo', e)} />
        </FormItem>
        <FormItem label={<span>名称</span>} field="name" {...formItemLayout}>
          <Input prefixCls="" value={form.name.value} className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label="类型" field="isFixed" {...formItemLayout}>
          <Select
            prefixCls=""
            className="search_Input"
            defaultOption={<Option value="">全部</Option>}
            value={form.isFixed.value}
            onChange={e => this.onSelectChange('isFixed', e)}
          >
            <Option value="1">固定点</Option>
            <Option value="0">移动点</Option>
          </Select>
        </FormItem>
        <FormItem label="分类" field="catalogId" {...formItemLayout}>
          <TreeSelect
            value={form.catalogId.value}
            allowClear
            className="search_Input"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={catalogData}
            placeholder="请选择"
            treeDefaultExpandAll
            onChange={e => this.onSelectChange('catalogId', e)}
          />
        </FormItem>
        <FormItem  className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

PointSearch.propTypes = {
  search: PropTypes.func
};

export default PointSearch;
