import React, { Component } from 'react';
import { Form, Input, Button } from 'amos-framework';
import PropTypes from 'prop-types';
import  './../../../styles/view/patrol/inputItem.scss';

const FormItem = Form.Item;

/**
 * 巡检项
 *
 * @class InputItemSearch
 * @extends {Component}
 */
class RouteSearch extends Component{
  constructor(props) {
    super(props);
    this.state = {
      form: {
        routeName: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        remark: {
          name: 'remark',
          type: 'LIKE',
          value: ''
        }
      }
    };
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  }

  handleSubmit = (e) => {
    const { form } = this.state;
    this.props.rearch(form);
  }

  render() {
    const { form } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo"  model={form} >
        <FormItem label="路线名称" field="routeName" {...formItemLayout} >
          <Input prefixCls="" className="search_Input" value={form.routeName.value} onChange={(e) => this.onChange('routeName', e)}
            // allowClear 
          />
        </FormItem>
        <FormItem label="备注说明" field="remark" {...formItemLayout} >
          <Input prefixCls="" className="search_Input" value={form.remark.value} onChange={(e) => this.onChange('remark', e)} />
        </FormItem>
        <FormItem className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>查询</Button>
        </FormItem>
      </Form>
    );
  }
}

RouteSearch.propTypes = {
  rearch: PropTypes.func
};

export default RouteSearch;
