import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosAlert } from 'amos-framework';
import { browserHistory } from 'amos-react-router';
import RouteMainxq from './RouteMainxq';
import RoutePointTablexq from './routePoint/RoutePointTablexq';
import { saveRouteAction, updateRouteAction } from '../../../services/checkService';
import BootBar from '../../component/toolbar';
import { Dropdown, Button, DropNav, Icon, Menu } from 'amos-framework';


/**
 * 路线编辑及新增页面
 * @class RouteInfo
 * @extends {Component}
*/
class RouteInfoxq extends Component {
  constructor(props) {
    super(props);
    this.state = {
      route: {},
      deptData: [],
      userData: [],
      dataList: [],
      routeId: ''
    };
  }

  componentWillMount =()=>{
    const { routeId, forword } = (this.props.location || {} ).state || {};
    routeId && this.setState({ routeId });
    forword && this.setState({ forword });
  }


  onClickBootBar = (type) => {
    if (type === '1') {
      browserHistory.goBack();
    } else if (type === '2') {
      this.saveRoute();
    }
  };



  setRoutePoint =(dataList)=>{
    this.setState({ dataList });
  }

  saveRoute = () => {
    this.routeMain.form.validate((valid, dataValues) => {
      if (valid) {
        const { form } = this.routeMain.state;
        const { data, deleteRowData } = this.routePoint.state;
        const { forword } = this.state;
        let requestBody = {};
        requestBody = Object.assign({},form);
        console.log(requestBody,'提交保存')
        requestBody.routePointList = [...data, ...deleteRowData];
        if (forword === 'edit'){
          updateRouteAction(requestBody).then(
            data => {
              AmosAlert.success('提示', '保存成功', {
                callback: () => {
                  browserHistory.goBack('/main/patrol/route');
                }
              });
            },
            error => {
              AmosAlert.error('错误', error);
            }
          );
        } else {
          saveRouteAction(requestBody).then(
            data => {
              AmosAlert.success('提示', '保存成功', {
                callback: () => {
                  browserHistory.goBack('/main/patrol/route');
                }
              });
            },
            error => {
              AmosAlert.error('错误', error);
            }
          );
        }

      } else {
        return false;
      }
    });
  };

  render() {
    const { routeId, forword } = this.state;
    return (
      <div className='route-info'>
        {/* <BootBar dropnavs={dropnavs} callBack={this.onClickBootBar} /> */}

        <RouteMainxq routeId={routeId}  ref={component => this.routeMain = component} />
        <RoutePointTablexq  routeId={routeId} forword={forword} ref={component =>this.routePoint = component} />
      </div>
    );
  }
}

RouteInfoxq.propTypes = {
  location: PropTypes.object
};

export default RouteInfoxq;
