import React, { Component } from 'react';
import { Form, Input, Button, Select } from 'amos-framework';
import PropTypes from 'prop-types';
import  './../../../styles/view/patrol/inputItem.scss';
import { queryDeptByOrgCodeAction1 } from '../../../services/checkService';
const FormItem = Form.Item;
const Option = Select.Option;
/**
 * 巡检项
 *
 * @class InputItemSearch
 * @extends {Component}
 */
class RouteSearch extends Component{
  constructor(props) {
    super(props);
    this.state = {
      form: {
        routeName: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        deptId: {
          name: 'deptId',
          value: ''
        },
        remark: {
          name: 'remark',
          type: 'LIKE',
          value: ''
        }
      },
      deptData: []
    };
    
  }
  componentWillMount() {
    // 查询部门
    this.queryDeptByOrgCode();
 
  }

  queryDeptByOrgCode = () => {
    queryDeptByOrgCodeAction1().then(data => {
      this.setState({ deptData: data });
    });
  };

  onDeptChange = (key, value) => {
    const { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  };

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  }

  handleSubmit = (e) => {
    const { form } = this.state;
    this.props.rearch(form);
  }

  render() {
    const { form, deptData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo"  model={form} >
        <FormItem label="路线名称" field="routeName" {...formItemLayout} >
          <Input prefixCls="" className="search_Input" value={form.routeName.value} onChange={(e) => this.onChange('routeName', e)} 
          // allowClear 
          />
        </FormItem>
        <FormItem label="责任部门" field="deptId" {...formItemLayout} >
          <Select
              // allowclear
              className="search_Input"
              data={deptData ? deptData : []}
              style={{ height:30}}
              renderOption={item => item && <Option value={item.sequenceNbr}>{item.departmentName}</Option>}
              defaultOption={<Option>全部</Option>}
              value={form.deptId.value }
              onChange={(e) => this.onDeptChange('deptId', e)}
            />
        </FormItem>
        <FormItem label="备注说明" field="remark" {...formItemLayout} >
          <Input prefixCls="" className="search_Input" value={form.remark.value} onChange={(e) => this.onChange('remark', e)} />
        </FormItem>
        <FormItem className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>查询</Button>
        </FormItem>
      </Form>
    );
  }
}

RouteSearch.propTypes = {
  rearch: PropTypes.func
};

export default RouteSearch;
