import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { DatePicker } from 'amos-antd';
import moment from 'moment';
import { Form, Button, Select, message } from 'amos-framework';
import {
  // caliberListAction,
  planListAction,
  lineListAction
} from './../../../../services/statisticsService';

const FormItem = Form.Item;
const Option = Select.Option;


/**
 * 消息提醒执行查询
 *
 * @class NewsSearch
 * @extends {Component}
 */
class NewsSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        startDate: {
          name: 'startDate',
          value: moment()
            .startOf('year')
            .format('YYYY-MM-DD')
        },
        endDate: {
          name: 'endDate',
          value: moment()
            .endOf('year')
            .format('YYYY-MM-DD')
        },
        statistical: { name: 'statistical', value: 'POINT' },
        planId: { name: 'planId', value: '' },
        routeId: { name: 'routeId', value: '' }
      },
      caliberList: [
        { id: 'POINT', name: '巡检点' },
        { id: 'ROUTE', name: '巡检线路' },
        // { id: 'DEPT', name: '巡检部门' },
        { id: 'USER', name: '巡检人员' },
        { id: 'PLAN', name: '巡检计划' }
      ],
      planList: [],
      lineList: []
    };
  }

  componentWillMount() {
    // caliberListAction().then(d => this.setState({ caliberList: d }));
    planListAction().then(d => this.setState({ planList: d }));
    lineListAction().then(d => this.setState({ lineList: d }));
    this.handleSubmit();
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState(form);
  }

  onDateChange = (key, date) => {
    const { form } = this.state;
    form[key].value = moment(date).format('YYYY-MM-DD HH:mm:ss');
    this.setState({ form });
  }

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState(form);
  }


  handleSubmit = () => {
    let { form } = this.state;
    const d1 = moment(form.endDate.value).format('YYYY');
    const d2 = moment(form.startDate.value).format('YYYY');
    console.log('---------', d1, d2, d1 - d2);
    if (d1 - d2 !== 0) {
      message.danger('开始日期和结束日期要在同一年');
      return;
    }
    const obj = {};
    Object.keys(form).map(e => {
      obj[e] = form[e].value;
    });
    this.props.search(obj);
  }

  render() {
    const { form, planList, caliberList, lineList } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo" model={form}>
        <FormItem label={<span>统计口径</span>} field="statistical" {...formItemLayout}>
          <Select
            data={caliberList}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={form.statistical.value}
            className="search_Input"
            onChange={e => this.onSelectChange('statistical', e)}
          />
        </FormItem>
        <FormItem label={<span>开始日期</span>} field="startDate" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.startDate.value)}
            allowClear={false}
            format="YYYY-MM-DD"
            onChange={e => this.onDateChange('startDate', e)}
          />
        </FormItem>
        <FormItem label={<span>结束日期</span>} field="endDate" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.endDate.value)}
            allowClear={false}
            format="YYYY-MM-DD"
            onChange={e => this.onDateChange('endDate', e)}
          />
        </FormItem>
        <FormItem label={<span>所属计划</span>} field="planId" {...formItemLayout}>
          <Select
            data={planList}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.planId.value}
            className="search_Input"
            onChange={e => this.onSelectChange('planId', e)}
          />
        </FormItem>
        <FormItem label={<span>所属线路</span>} field="routeId" {...formItemLayout}>
          <Select
            data={lineList}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.routeId.value}
            className="search_Input"
            onChange={e => this.onSelectChange('routeId', e)}
          />
        </FormItem>
        <FormItem className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

NewsSearch.propTypes = {
  search: PropTypes.func
};

export default NewsSearch;
