import React, { Component } from 'react';
import PropTypes from 'prop-types';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { Table } from 'amos-antd';
import { exportExcel } from 'UTILS/tools';
import { patrolUrls } from 'CONSTS/urlConsts';
import ToolBar from './../../../component/toolbar';
import './../../../../styles/view/patrol/statistics.scss';

const dropnavs = [
  {
    key: '1',
    text: '导出Excel',
    icon: 'user',
    href: 'jacascript::void(0)'
  },
  {
    key: '2',
    text: '备注：查询结果为计划任务个数和计划任务完成个数',
    href: 'jacascript::void(0)'
  }
];
/**
 * 巡检完成情况月报表-表格
 *
 * @class TableContent
 * @extends {Component}
 */
class TableContent extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  onExportExcel = () => {
    const { searchParam } = this.props;
    exportExcel({ url: formatUrl(patrolUrls.completionSituationExportUrl, searchParam), method: 'get' }, '巡检完成情况月报表');
  }

  onClickBootBar = type => {
    if (type === '1') {
      this.onExportExcel();
    }
  };

  renderTitle = (monthColumns) => {
    let titleCol = {
      title: '项目名称',
      dataIndex: '0',
      key: '0',
      className: 'uant-table-thead',
      width: 50
    };
    let index = 0;
    let cols = monthColumns.map( e => {
      let month = e;
      if (e < 10) {
        month = `0${e}`;
      }
      let children = new Array();
      index = index + 1;
      children.push({
        title: '计划',
        dataIndex: index,
        key: `taskCountWait${month}`,
        width: 10,
        render: (text, record) => {
          return this.inQueryTime(parseInt(month)) ? <strong>{text}</strong> : text;
        }
      });
      index = index + 1;
      children.push({
        title: '完成',
        dataIndex: index,
        key: `taskCountFinish${month}`,
        width: 10,
        render: (text, record) => {
          return this.inQueryTime(parseInt(month)) ? <strong>{text}</strong> : text;
        }
      });
      let col =  {
        title: `${e}月`,
        children
      };
      return col;
    });
    const columns = [titleCol, ...cols];
    return columns;
  }

  inQueryTime(month) {
    const { searchParam } = this.props;
    let startDate = new Date(searchParam.startDate);
    let endDate = new Date(searchParam.endDate);
    let startMonth = startDate.getMonth() + 1;
    let endMonth = endDate.getMonth() + 1;

    if  (startMonth <= month && endMonth >= month) {
      return true;
    }
    return false;
  }

  render() {
    const { data } = this.props;
    const month = 12;
    const columns = [...Array(month)].map((e, index) => index + 1);
    const _pagination_ = false;
    return (
      <div className="patrol-page-table">
        <ToolBar dropnavs={dropnavs} callBack={this.onClickBootBar} />
        <div className="completion-situation-table">
          <Table
            rowKey={(record, index) => record.index}
            columns={this.renderTitle(columns)}
            pagination={_pagination_}
            bordered
            dataSource={data}
            scroll={{ x: true, y: 500 }}
          />
        </div>
      </div>
    );
  }
}

TableContent.propTypes = {
  searchParam: PropTypes.array,
  data: PropTypes.any
};

export default TableContent;
