import React, { Component } from 'react';
import SplitterLayout from './../../../component/SplitLayout';
import {
  completionSituationAction
} from './../../../../services/statisticsService';
import Search from './Search';
import Table from './Table';

const ten = 10;
const mouth = 12;
/**
 * 年度巡检情况报表
 *
 * @class CompletionSituation
 * @extends {Component}
 */
class CompletionSituation extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tableData: [],
      searchParam: []
    };
  }

  onQueryTableData = () => {
    const { searchParam } = this.state;
    completionSituationAction(searchParam).then(d => {
      d.summation.itemName = '合计';
      const list = [...d.dataByMonth, d.summation];
      const tableData = list.map(e => {
        let sun = [];
        sun.push(e.itemName);
        for (let i = 1; i <= mouth; i++){
          sun.push(e[`taskCountWait${i < ten ? 0 : ''}${i}`]);
          sun.push(e[`taskCountFinish${i < ten ? 0 : ''}${i}`]);
        }
        return sun;
      });
      this.setState({ tableData });
    });
  }

  onSearchDataSyn = (searchParam) => {
    this.setState({ searchParam }, this.onQueryTableData);
  };

  render() {
    const { tableData, searchParam } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <Search search={this.onSearchDataSyn} />
        </SplitterLayout>
        <Table data={tableData} searchParam={searchParam} />
      </div>
    );
  }
}

export default CompletionSituation;
