import React, { Component } from 'react';
import { browserHistory } from 'amos-react-router';
import { pathMapping } from './../../../routes/customRoutes';
/**
 * 查询统计
 *
 * @class Statistics
 * @extends {Component}
 */
class Statistics extends Component {
  constructor(props) {
    super(props);
    this.state = {
      statisticsList: [
        { key: '1', name: '巡检情况统计分析', href: pathMapping.inspectionSituation },
        { key: '2', name: '任务安排统计分析', href: pathMapping.taskArrangement },
        // { key: '3', name: '检查项目查询', href: '' },
        // { key: '4', name: '检查项目统计分析', href: '' },
        { key: '5', name: '年度巡检情况报表', href: pathMapping.completionsituation },
        // { key: '6', name: '巡检评分情况月报表', href: '' },
        { key: '7', name: '人员综合统计分析', href: pathMapping.personStatistics },
        { key: '8', name: '月度巡检情况报表', href: pathMapping.monthSituation }
        // { key: '8', name: '计划执行情况查询', href: '' },
        // { key: '9', name: '数字检查项日报表', href: '' },
        // { key: '10', name: '数字检查项统计分析', href: '' }
      ]
    };
  }
  /**
   * 处理跳转到具体的统计项页面中
   * @memberof Statistics
   */
  onClick = (item) => {
    if (item.href) {
      browserHistory.push(item.href);
    }
  }

  render() {
    const { statisticsList } = this.state;
    return (
      <div className="statistics-content">
        {
          statisticsList.map(e => (
            <div className="statistics-item" key={e.key} onClick={()=>this.onClick(e)}>
              <img src="/src/assets/fsc/img/stat.png" alt="" />
              <span>{e.name}</span>
            </div>
          ))
        }
      </div>
    );
  }
}

export default Statistics;
