import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { DatePicker } from 'amos-antd';
import moment from 'moment';
import { Form, Button, Select, Input } from 'amos-framework';
import {
  caliberListAction,
  planListAction,
  lineListAction,
  executeStateListAction
} from './../../../../services/statisticsService';

const FormItem = Form.Item;
const Option = Select.Option;


/**
 * 巡检情况统计分析-查询
 *
 * @class NewsSearch
 * @extends {Component}
 */
class NewsSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        startTime: {
          name: 'startTime',
          value: moment()
            .startOf('day')
            .format('YYYY-MM-DD HH:mm:ss')
        },
        endTime: {
          name: 'endTime',
          value: moment()
            .endOf('day')
            .format('YYYY-MM-DD HH:mm:ss')
        },
        isFixed: { name: 'isFixed', value: undefined },
        isOk: { name: 'isOk', value: undefined },
        planId: { name: 'planId', value: undefined },
        pointName: { name: 'pointName', value: undefined },
        pointNo: { name: 'pointNo', value: '' },
        processType: { name: 'processType', value: undefined },
        routeId: { name: 'routeId', value: undefined },
        statisticsTyle: { name: 'statisticsTyle', value: '0' },
        userName: { name: 'userName', value: '' }
      },
      caliberList: [],
      planList: [],
      lineList: [],
      executeStateList: []
    };
  }

  componentWillMount() {
    caliberListAction().then(d => this.setState({ caliberList: d }));
    planListAction().then(d => this.setState({ planList: d }));
    lineListAction().then(d => this.setState({ lineList: d }));
    executeStateListAction().then(d => this.setState({ executeStateList: d }));
    this.handleSubmit();
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState(form);
  }

  onDateChange = (key, date) => {
    const { form } = this.state;
    form[key].value = moment(date).format('YYYY-MM-DD HH:mm:ss');
    this.setState({ form });
  }

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState(form);
  }


  handleSubmit = () => {
    let { form } = this.state;
    const obj = {};
    Object.keys(form).map(e => {
      obj[e] = form[e].value;
    });
    this.props.search(obj);
  }

  render() {
    const { form, planList, caliberList, lineList, executeStateList } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo" model={form}>
        <FormItem label={<span>统计口径</span>} field="statisticsTyle" {...formItemLayout}>
          <Select
            data={caliberList}
            renderOption={item => <Option value={item.value}>{item.name}</Option>}
            value={form.statisticsTyle.value}
            className="search_Input"
            onChange={e => this.onSelectChange('statisticsTyle', e)}
          />
        </FormItem>
        <FormItem label={<span>开始日期</span>} field="startTime" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.startTime.value)}
            allowClear={false}
            format="YYYY-MM-DD"
            onChange={e => this.onDateChange('startTime', e)}
          />
        </FormItem>
        <FormItem label={<span>结束日期</span>} field="endTime" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.endTime.value)}
            allowClear={false}
            format="YYYY-MM-DD"
            onChange={e => this.onDateChange('endTime', e)}
          />
        </FormItem>
        <FormItem label={<span>巡检人员</span>} field="userName" {...formItemLayout}>
          <Input prefixCls="" value={form.userName.value} className="search_Input" onChange={e => this.onChange('userName', e)} />
        </FormItem>
        <FormItem label={<span>点编号</span>} field="pointNo" {...formItemLayout}>
          <Input prefixCls="" value={form.pointNo.value} className="search_Input" onChange={e => this.onChange('pointNo', e)} />
        </FormItem>
        <FormItem label={<span>点名称</span>} field="pointName" {...formItemLayout}>
          <Input prefixCls="" value={form.pointName.value} className="search_Input" onChange={e => this.onChange('pointName', e)} />
        </FormItem>
        <FormItem label={<span>点类型</span>} field="isFixed" {...formItemLayout}>
          <Select
            data={[{ id: 1, name: '固定点' }, { id: 0, name: '移动点' }]}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option>全部</Option>}
            value={form.isFixed.value}
            className="search_Input"
            onChange={e => this.onSelectChange('isFixed', e)}
          />
        </FormItem>
        <FormItem label={<span>执行情况</span>} field="processType" {...formItemLayout}>
          <Select
            data={executeStateList}
            renderOption={item => <Option value={item.value}>{item.name}</Option>}
            defaultOption={<Option>全部</Option>}
            value={form.processType.value}
            className="search_Input"
            onChange={e => this.onSelectChange('processType', e)}
          />
        </FormItem>
        <FormItem label={<span>是否合格</span>} field="isOk" {...formItemLayout}>
          <Select
            data={[{ id: '1', name: '正常' }, { id: '2', name: '异常' }]}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option>全部</Option>}
            value={form.isOk.value}
            className="search_Input"
            onChange={e => this.onSelectChange('isOk', e)}
          />
        </FormItem>
        <FormItem label={<span>所属计划</span>} field="planId" {...formItemLayout}>
          <Select
            data={planList}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option>全部</Option>}
            value={form.planId.value}
            className="search_Input"
            onChange={e => this.onSelectChange('planId', e)}
          />
        </FormItem>
        <FormItem label={<span>所属线路</span>} field="routeId" {...formItemLayout}>
          <Select
            data={lineList}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option>全部</Option>}
            value={form.routeId.value}
            className="search_Input"
            onChange={e => this.onSelectChange('routeId', e)}
          />
        </FormItem>
        <FormItem  className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

NewsSearch.propTypes = {
  search: PropTypes.func
};

export default NewsSearch;
