import React, { Component } from 'react';
import SplitterLayout from './../../../component/SplitLayout';
import {
  inspectionSituationListAction
} from './../../../../services/statisticsService';
import Search from './Search';
import Table from './Table';
/**
 * 巡检情况统计分析
 *
 * @class InspectionSituation
 * @extends {Component}
 */
class InspectionSituation extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tableData: [],
      searchParam: []
    };
  }

  onQueryTableData = () => {
    const { searchParam } = this.state;
    inspectionSituationListAction(searchParam).then(d => {
      this.setState({ tableData: d });
    });
  }

  onSearchDataSyn = (searchParam) => {
    this.setState({ searchParam }, this.onQueryTableData);
  };

  render() {
    const { tableData, searchParam } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <Search search={this.onSearchDataSyn} />
        </SplitterLayout>
        <Table dataList={tableData} searchParam={searchParam} />
      </div>
    );
  }
}

export default InspectionSituation;
