import React, { Component } from 'react';
import PropTypes from 'prop-types';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { Table } from 'amos-antd';
import { exportExcel } from 'UTILS/tools';
import { patrolUrls } from 'CONSTS/urlConsts';
import ToolBar from './../../../component/toolbar';
import './../../../../styles/view/patrol/statistics.scss';
import { utils } from 'amos-tool';
import moment from 'moment';

const dropnavs = [
  {
    key: '1',
    text: '导出Excel',
    icon: 'user',
    href: 'jacascript::void(0)'
  }
];
/**
 * 月度巡检情况报表-表格
 *
 * @class TableContent
 * @extends {Component}
 */
class MonthSituationTable extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  onExportExcel = () => {
    const { searchParam } = this.props;
    const millisecond = moment().format('YYYYMMDDHHmmss');
    exportExcel({ url: patrolUrls.monthSituationExportUrl, method: 'post', body: searchParam }, '月度巡检情况报表' + millisecond);
  }

  onClickBootBar = type => {
    if (type === '1') {
      this.onExportExcel();
    }
  };

  renderTitle = (titles) => {
    let titleCol = {
      title: '巡检日期',
      dataIndex: '0',
      key: 'month',
      className: 'uant-table-thead',
      width: 25,
      render: (text, record)=><strong>{record.month}</strong>
    };
    let index = 0;
    let cols = titles && titles.map( e => {
      let children = new Array();
      index = index + 1;
      children.push({
        title: '计划巡检次数',
        dataIndex: index,
        key: `planTaskCount${e.key}`,
        width: 20,
        render: (text, record) => {
          let num = utils.isEmpty(record[`planTaskCount${e.key}`]) ? 0 : record[`planTaskCount${e.key}`];
          return <strong>{num}</strong>;
        }
      });
      index = index + 1;
      children.push({
        title: '实际巡检次数',
        dataIndex: index,
        key: `checkCount${e.key}`,
        width: 20,
        render: (text, record) => {
          let num = utils.isEmpty(record[`checkCount${e.key}`]) ? 0 : record[`checkCount${e.key}`];
          return <strong>{num}</strong>;
        }
      });
      index = index + 1;
      children.push({
        title: '漏检次数',
        dataIndex: index,
        key: `missed${e.key}`,
        width: 20,
        render: (text, record) => {
          let num = utils.isEmpty(record[`missed${e.key}`]) ? 0 : record[`missed${e.key}`];
          return <strong>{num}</strong>;
        }
      });
      index = index + 1;
      children.push({
        title: '异常次数',
        dataIndex: index,
        key: `faild${e.key}`,
        width: 20,
        render: (text, record) => {
          let num = utils.isEmpty(record[`faild${e.key}`]) ? 0 : record[`faild${e.key}`];
          return <strong>{num}</strong>;
        }
      });
      let col =  {
        title: `${e.label}`,
        children
      };
      return col;
    });
    const columns = [titleCol, ...cols];
    return columns;
  }

  render() {
    const { data, titles } = this.props;
    const _pagination_ = false;
    return (
      <div className="patrol-page-table">
        <ToolBar dropnavs={dropnavs} callBack={this.onClickBootBar} />
        <div className="completion-situation-table">
          <Table
            rowKey={(record, index) => record.index}
            columns={this.renderTitle(titles)}
            pagination={_pagination_}
            bordered
            dataSource={data}
            scroll={{ x: true, y: 500 }}
          />
        </div>
      </div>
    );
  }
}

MonthSituationTable.propTypes = {
  searchParam: PropTypes.array,
  data: PropTypes.any,
  titles: PropTypes.array
};

export default MonthSituationTable;
