import React, { Component } from 'react';
import SplitterLayout from './../../../component/SplitLayout';
import {
  personStatisticsAction
} from './../../../../services/statisticsService';
import Search from './Search';
import Table from './Table';
/**
 * 人员综合统计分析
 *
 * @class PersonStatistics
 * @extends {Component}
 */
class PersonStatistics extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tableData: [],
      searchParam: []
    };
  }

  onQueryTableData = () => {
    const { searchParam } = this.state;
    personStatisticsAction(searchParam).then(data =>{
      const list = data.report || [];
      data.summation && (data.summation.userName = '合计');
      list.push(data.summation);
      this.setState({
        tableData: list
      });
    });
  }

  onSearchDataSyn = (searchParam) => {
    this.setState({ searchParam }, this.onQueryTableData);
  };

  render() {
    const { tableData, searchParam } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <Search search={this.onSearchDataSyn} />
        </SplitterLayout>
        <Table searchParam={searchParam} dataList={tableData} />
      </div>
    );
  }
}

export default PersonStatistics;
