import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { DatePicker } from 'amos-antd';
import moment from 'moment';
import { Form, Button, Select } from 'amos-framework';
import {
  taskCaliberListAction
} from './../../../../services/statisticsService';

const FormItem = Form.Item;
const Option = Select.Option;


/**
 * 任务安排统计分析-查询
 *
 * @class NewsSearch
 * @extends {Component}
 */
class NewsSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        startTime: {
          name: 'startTime',
          value: moment()
            .startOf('year')
            .format('YYYY-MM-DD HH:mm:ss')
        },
        endTime: {
          name: 'endTime',
          value: moment()
            .endOf('year')
            .format('YYYY-MM-DD HH:mm:ss')
        },
        statisticsTyle: { name: 'statisticsTyle', value: '0' }
      },
      caliberList: []
    };
  }

  componentWillMount() {
    taskCaliberListAction().then(d => this.setState({ caliberList: d }));
    this.handleSubmit();
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState(form);
  }

  onDateChange = (key, date) => {
    const { form } = this.state;
    form[key].value = moment(date).format('YYYY-MM-DD HH:mm:ss');
    this.setState({ form });
  }

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState(form);
  }


  handleSubmit = () => {
    let { form } = this.state;
    const obj = {};
    Object.keys(form).map(e => {
      obj[e] = form[e].value;
    });
    this.props.search(obj);
  }

  render() {
    const { form, caliberList } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo" model={form}>
        <FormItem label={<span>统计口径</span>} field="statisticsTyle" {...formItemLayout}>
          <Select
            data={caliberList}
            renderOption={item => <Option value={item.value}>{item.name}</Option>}
            value={form.statisticsTyle.value}
            className="search_Input"
            onChange={e => this.onSelectChange('statisticsTyle', e)}
          />
        </FormItem>
        <FormItem label={<span>开始日期</span>} field="startTime" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.startTime.value)}
            allowClear={false}
            format="YYYY-MM-DD HH:mm:ss"
            onChange={e => this.onDateChange('startTime', e)}
          />
        </FormItem>
        <FormItem label={<span>结束日期</span>} field="endTime" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.endTime.value)}
            allowClear={false}
            format="YYYY-MM-DD HH:mm:ss"
            onChange={e => this.onDateChange('endTime', e)}
          />
        </FormItem>
        <FormItem className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

NewsSearch.propTypes = {
  search: PropTypes.func
};

export default NewsSearch;
