import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { exportExcel } from 'UTILS/tools';
import { patrolUrls } from 'CONSTS/urlConsts';
import AmosGridTable from './../../../component/table/table/AmosGridTable';
import ToolBar from './../../../component/toolbar';

const dropnavs = [
  {
    key: '1',
    text: '导出Excel',
    icon: 'user',
    href: 'jacascript::void(0)'
  },
  {
    key: '2',
    text: '备注：统计结果为任务安排执行情况个数',
    href: 'jacascript::void(0)'
  }
];
const getColumns = () => {
  return [
    {
      title: '项目名称',
      dataIndex: 'name',
      key: 'name',
      width: 160,
      className: 'uant-table-thead'
    },
    {
      title: '处理中',
      dataIndex: 'proccesed',
      key: 'proccesed',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '已完成',
      dataIndex: 'finished',
      key: 'finished',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '已取消',
      dataIndex: 'cancel',
      key: 'cancel',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '已超时',
      dataIndex: 'timeout',
      key: 'timeout',
      width: 120,
      className: 'uant-table-thead'
    }
  ];
};

/**
 * 任务安排统计分析-表格
 *
 * @class TaskArrangementTable
 * @extends {Component}
 */
class TaskArrangementTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: true,
      selectedRows: [],
      selectedRowKeys: [],
      data: []
    };
  }

  onExportExcel = () => {
    const { searchParam } = this.props;
    exportExcel({ url: patrolUrls.taskArrangementExportUrl, method: 'post', body: searchParam }, '任务安排统计分析报表');
  }

  onClickBootBar = type => {
    if (type === '1') {
      this.onExportExcel();
    }
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  render() {
    let { dataList } = this.props;
    let { selectedRowKeys } = this.state;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="patrol-page-table">
        <ToolBar dropnavs={dropnavs} callBack={this.onClickBootBar} />
        <AmosGridTable
          columns={getColumns()}
          callBack={this.reload}
          dataList={dataList}
          selectedRowKeys={selectedRowKeys}
          getTableDataAction={()=>{}}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          isPageable={false}
          isChecked={false}
        />
      </div>
    );
  }
}

TaskArrangementTable.propTypes = {
  queryParam: PropTypes.object,
  dataList: PropTypes.array,
  fetchData: PropTypes.func,
  count: PropTypes.number,
  searchParam: PropTypes.array
};

export default TaskArrangementTable;
