import React, { Component } from 'react';
import SplitterLayout from './../../../component/SplitLayout';
import {
  taskArrangementListAction
} from './../../../../services/statisticsService';
import Search from './Search';
import Table from './Table';
/**
 * 任务安排统计分析
 *
 * @class TaskArrangement
 * @extends {Component}
 */
class TaskArrangement extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tableData: [],
      searchParam: []
    };
  }

  onQueryTableData = () => {
    const { searchParam } = this.state;
    taskArrangementListAction(searchParam).then(data =>{
      this.setState({
        tableData: data
      });
    });
  }

  onSearchDataSyn = (searchParam) => {
    this.setState({ searchParam }, this.onQueryTableData);
  };

  render() {
    const { tableData, searchParam } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <Search search={this.onSearchDataSyn} />
        </SplitterLayout>
        <Table searchParam={searchParam} dataList={tableData} />
      </div>
    );
  }
}

export default TaskArrangement;
