import React, { Component } from 'react';
import { Form, Input, Button, Select } from 'amos-framework';

import PropTypes from 'prop-types';
import  './../../../styles/view/patrol/inputItem.scss';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 * 巡检项
 *
 * @class TaskSearch
 * @extends {Component}
 */
class TaskSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        title: {
          name: 'title',
          type: 'LIKE',
          value: ''
        },
        remark: {
          name: 'remark',
          type: 'LIKE',
          value: ''
        },
        status: {
          name: 'status',
          type: 'LIKE',
          value: ''
        }
      }
    };
  }
  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  }
  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  }
  handleSubmit = (e) => {
    const { form } = this.state;
    this.props.rearch(form);
  }
  render() {
    const { form } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo"  model={form} >
        <FormItem label={<span>任务标题</span>} field="title" {...formItemLayout} >
          <Input value={form.title.value} prefixCls="" className="search_Input" onChange={(e) => this.onChange('title', e)} />
        </FormItem>
        <FormItem label="任务类型" field="status" {...formItemLayout} >
          <Select defaultOption={<Option value="">全部</Option>} className="search_Input" value={form.status.value} onChange={(e) => this.onSelectChange('status', e)}>
            <Option value="0">处理中</Option>
            <Option value="1">已完成</Option>
            <Option value="2">已取消</Option>
            <Option value="3">已超时</Option>
          </Select>
        </FormItem>
        <FormItem label="任务内容" field="remark" {...formItemLayout} >
          <Input prefixCls="" className="search_Input" value={form.remark.value} onChange={(e) => this.onChange('remark', e)} />
        </FormItem>
        <FormItem className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>查询</Button>
        </FormItem>
      </Form>
    );
  }
}

TaskSearch.propTypes = {
  rearch: PropTypes.func
};

export default TaskSearch;
