/**
 * 鎿嶄綔鏋氫妇
 */
export const QueryOperatorEnum = {
  LESS_VALUE: { value: 1, code: 'LESS', name: 1 },
  BIGGER_VALUE: { value: 2, code: 'BIGGER', name: 2 },
  EQUAL_VALUE: { value: 3, code: 'EQUAL', name: 3 },
  LESS_EQUAL_VALUE: { value: 4, code: 'LESS', name: 4 },
  BIGGER_EQUAL_VALUE: { value: 5, code: 'BIGGER', name: 5 },
  NOT_EQUAL_VALUE: { value: 6, code: 'NOT', name: 6 },
  IN_VALUE: { value: 7, code: 'IN', name: 7 },
  LIKE_VALUE: { value: 8, code: 'LIKE', name: 8 },
  OR_VALUE: { value: 9, code: 'OR', name: 9 },
  ORDER_VALUE: { value: 10, code: 'ORDER BY', name: 10 },
  NOT_IN_VALUE: { value: 11, code: 'NOT IN', name: 11 },
  IS_VALUE: { value: 12, code: 'NOT IN', name: 12 },
};

export const JsJComparisonOperatorsEnum = {
  EQUAL_VALUE: { value: '===', name: '等于' },
  LESS_EQUAL_VALUE: { value: '<=', name: '小于等于' },
  LESS_VALUE: { value: '<', name: '小于' },
  BIGGER_EQUAL_VALUE: { value: '>=', name: '大于等于' },
  BIGGER_VALUE: { value: '>', name: '大于' },
  NO_EQUAL_VALUE: { value: '!==', name: '不等于' }
};



/**
 * 数据表类型
 */
export const tableTypesEnum = {
  TABLE: { key: 'TABLE', label: '表格', value: 'TABLE' },
  VIEW: { key: 'VIEW', label: '视图', value: 'VIEW' }
};

/**
 * 角色设定
 */
export const roleSettingEnum = {
  regular: { key: 'regular', label: '自变量', value: 'regular' },
  id: { key: 'id', label: 'ID', value: 'id' },
  label: { key: 'label', label: '因变量', value: 'label' },
  subgroup: { key: 'subgroup', label: '子组', value: 'subgroup' }
};
/**
 * 角色设定
 */
export const portTypeEnum = {
  DATA: { key: 'dataset', label: '数据集(D)', value: 'dataset' },
  MODEL: { key: 'model', label: '模型(M)', value: 'model' },
  GRAPH: { key: 'graph', label: '图表(G)', value: 'graph' }
};

export const flowRunStatusEnum = {
  PROCESS_STATE_FAILED: { value: '-2' },
  PROCESS_STATE_UNKNOWN: { value: '-1' },
  PROCESS_STATE_STOPPED: { value: '0' },
  PROCESS_STATE_PAUSED: { value: '1' },
  PROCESS_STATE_RUNNING: { value: '2' },
  PROCESS_STATE_FINISH: { value: '3' }
};
/**
 * spc校验准则
 */
export const spcRulesEnum = {
  RULES_1_BEYOND_KSIGMA: { key: 'RULES_1_BEYOND_KSIGMA', label: '一个点，距离中心线大于K个标准差', value: 'RULES_1_BEYOND_KSIGMA' },
  RULES_K_ON_ONE_SIDE: { key: 'RULES_K_ON_ONE_SIDE', label: '连续k点在中心线同一侧', value: 'RULES_K_ON_ONE_SIDE' },
  RULES_K_TRENDING: { key: 'RULES_K_TRENDING', label: '连续k个点，全部递增或全部递增', value: 'RULES_K_TRENDING' },
  RULES_K_UP_DOWN: { key: 'RULES_K_UP_DOWN', label: '连续k个点，上下交错', value: 'RULES_K_UP_DOWN' },
  'RULES_K_OF_K+1_BEYOND_2SIGMA': { key: 'RULES_K_OF_K+1_BEYOND_2SIGMA', label: 'K+1个点中有K个点，距离中心线（同侧）大于2个标准差', value: 'RULES_K_OF_K+1_BEYOND_2SIGMA' },
  'RULES_K_OF_K+1_BEYOND_1SIGMA': { key: 'ULES_K_OF_K+1_BEYOND_1SIGMA', label: '1个点中有K个点，距离中心线（同侧）大于1个标准差', value: 'ULES_K_OF_K+1_BEYOND_1SIGMA' },
  RULES_K_BELOW_1SIGMA: { key: 'RULES_K_BELOW_1SIGMA', label: '连续K个点，距离中心线（任一侧）1个标准差以内', value: 'RULES_K_BELOW_1SIGMA' },
  RULES_K_BEYOND_1SIGMA_BOTH_SIDES: { key: 'RULES_K_BEYOND_1SIGMA_BOTH_SIDES', label: '连续K个点，距离中心线（任一侧）大于1个标准差', value: 'RULES_K_BEYOND_1SIGMA_BOTH_SIDES' },
};

/**
 * 洞察结果数据分类枚举
 */
export const insightDataCategoryEnum = {
  Table: { value: 'Table', label: '输出数据' },
  Statistics: { value: 'Statistics', label: '统计信息' },
  model: { value: 'model', label: '模型' },
  Text: { value: 'Text', label: '描述' },
  Node: { value: 'Node', label: '节点' }
};

export const insightCategoryEnum = {
  dataset: { value: 'dataset', label: '数据集' },
  model: { value: 'model', label: '模型' },
  graph: { value: 'graph', label: '图表' },
  describe: { value: 'describe', label: '节点描述' }
};

export const pointTypes = {
  DATA: 'dataset',
  MODEL: 'model',
  NON: 'non',
  GRAPH: 'graph',
  RESULT: 'result',
  INPUT: 'input'
};
/**
 * 数据输出类型枚举
 */
export const dataTypeEnum = {
  VARCHAR: { value: 'VARCHAR', type: 'STRING', label: '字符串类型', icon: 'string', defaultLength: 256, accuracy: -1, maxLength: 10485760 },
  TEXT: { value: 'TEXT', type: 'STRING', label: '长文本类型', icon: 'text', defaultLength: -1, accuracy: -1 },
  INT: { value: 'INT', type: 'DOUBLE', label: '数值型(INT)', icon: 'int', defaultLength: 9, accuracy: -1, maxLength: 255 },
  LONG: { value: 'LONG', type: 'DOUBLE', label: '数值型(LONG)', icon: 'long', defaultLength: 16, accuracy: -1, maxLength: 255 },
  FLOAT: { value: 'FLOAT', type: 'DOUBLE', label: '数值型(FLOAT)', icon: 'float', defaultLength: 38, accuracy: 2, maxLength: 255 },
  DOUBLE: { value: 'DOUBLE', type: 'DOUBLE', label: '数值型(DOUBLE)', icon: 'double', defaultLength: 38, accuracy: 2, maxLength: 255 },
  DATE: { value: 'DATE', type: 'DATE', label: '日期型', icon: 'date', defaultLength: -1, accuracy: -1 },
  TIME: { value: 'TIME', type: 'DATE', label: '时间型', icon: 'time', defaultLength: -1, accuracy: -1 },
  DATETIME: { value: 'DATETIME', type: 'DATE', label: '日期时间型', icon: 'datetime', defaultLength: -1, accuracy: -1 }
};

export const columnTypesEnum = {
  STRING: { key: 'STRING', label: '字符型', value: 'STRING' },
  DOUBLE: { key: 'DOUBLE', label: '数值型', value: 'DOUBLE' },
  DATE: { key: 'DATE', label: '日期型', value: 'DATE' }
};
/**
 * 字符型属性变换方式枚举
 */
export const stringConvertModeEnum = {
  double: { value: 'TRANSFORMDOUBLE', label: '字符转数字(DOUBLE)', type: dataTypeEnum.DOUBLE.value },
  float: { value: 'TRANSFORMFLOAT', label: '字符转数字(FLOAT)', type: dataTypeEnum.FLOAT.value },
  int: { value: 'TRANSFORMINT', label: '字符转数字(INT)', type: dataTypeEnum.INT.value },
  long: { value: 'TRANSFORMLONG', label: '字符转数字(LONG)', type: dataTypeEnum.LONG.value },
  date: { value: 'TRANSFORMDATE', label: '字符转日期', type: dataTypeEnum.DATE.value },
  null: { value: 'NULL', label: '空值转换', type: dataTypeEnum.VARCHAR.value },
  noNull: { value: 'NOTNULL', label: '非空值转换', type: dataTypeEnum.VARCHAR.value },
  subString: { value: 'SUBSTRING', label: '取子串', type: dataTypeEnum.VARCHAR.value },
  text: { value: 'REPLACE', label: '文本替换', type: dataTypeEnum.VARCHAR.value },
  uppercase: { value: 'UPPERCASE', label: '转大写', type: dataTypeEnum.VARCHAR.value },
  lowercase: { value: 'LOWERCASE', label: '转小写', type: dataTypeEnum.VARCHAR.value },
  trimSpace: { value: 'UNWHITESPACE', label: '去空格', type: dataTypeEnum.VARCHAR.value },
  trimChart: { value: 'REMOVE', label: '去字符', type: dataTypeEnum.VARCHAR.value }
};
/**
 * 数值型属性变换方式枚举
 */
export const numberConvertModeEnum = {
  string: { value: 'NUMBERTOSTRING', label: '数字转字符', type: dataTypeEnum.VARCHAR.value },
  section: { value: 'INTERVALTOSTRING', label: '区间转字符', type: dataTypeEnum.VARCHAR.value },
  number: { value: 'NUMBERTODATE', label: '数字转日期', type: dataTypeEnum.DATE.value },
  square: { value: 'SQUARE', label: '平方', type: dataTypeEnum.DOUBLE.value },
  squareRoot: { value: 'SQUAREROOT', label: '平方根', type: dataTypeEnum.DOUBLE.value },
  logarithm: { value: 'LOGARITHM', label: '对数', type: dataTypeEnum.DOUBLE.value },
  null: { value: 'NUMBERNULL', label: '空值转换', type: dataTypeEnum.DOUBLE.value },
  noNull: { value: 'NUMBERNOTNULL', label: '非空值转换', type: dataTypeEnum.DOUBLE.value },
  rounding: { value: 'ROUNDING', label: '四舍五入', type: dataTypeEnum.DOUBLE.value }
};
/**
 * 日期型属性变换方式枚举
 */
export const dateConvertModeEnum = {
  string: { value: 'DATETOSTRING', label: '日期转字符', type: dataTypeEnum.VARCHAR.value },
  long: { value: 'INTERVALTOLONG', label: '区间转数字(LONG)', type: dataTypeEnum.LONG.value },
  int: { value: 'INTERVALTOINT', label: '区间转数字(INT)', type: dataTypeEnum.INT.value },
  double: { value: 'INTERVALTODOUBLE', label: '区间转数字(DOUBLE)', type: dataTypeEnum.DOUBLE.value },
  float: { value: 'INTERVALTOFLOAT', label: '区间转数字(FLOAT)', type: dataTypeEnum.FLOAT.value },
  sectionString: { value: 'INTERVALTOCHARACTOR', label: '区间转字符', type: dataTypeEnum.VARCHAR.value },
  subdata: { value: 'SUBDATE', label: '截取日期', type: dataTypeEnum.VARCHAR.value },
  format: { value: 'DATEFORMAT', label: '日期格式转换', type: dataTypeEnum.VARCHAR.value }
};

/**
 * 日期截取字段枚举
 */
export const subDateEnum = {
  y: { value: '年', label: '年' },
  m: { value: '月', label: '月' },
  d: { value: '日', label: '日' },
  hh: { value: '时', label: '时' },
  mm: { value: '分', label: '分' },
  ss: { value: '秒', label: '秒' }
};

/**
 * 日期转换格式枚举
 */
export const dateFormatEnum = {
  format1: { value: 'yyyy/M/d', label: 'yyyy/M/d' },
  format2: { value: 'yyyy-M-d', label: 'yyyy-M-d' },
  format3: { value: 'yyyy.M.d', label: 'yyyy.M.d' },
  format4: { value: 'yyyy/MM/dd', label: 'yyyy/MM/dd' },
  format5: { value: 'yyyy-MM-dd', label: 'yyyy-MM-dd' },
  format6: { value: 'yyyy.MM.dd', label: 'yyyy.MM.dd' },
  format8: { value: 'yy-M-d', label: 'yy-M-d' },
  format9: { value: 'yyM/d', label: 'yy/M/d' },
  format7: { value: 'yy.M.d', label: 'yy.M.d' },
  format10: { value: 'yy/MM/dd', label: 'yy/MM/dd' }
};

/**
 * 数据连接 连接方式枚举
 */
export const dateConnModeEnum = {
  string: { value: 'inner', label: '内连接(给定条件，仅返回匹配的行)', backgroundPosition: '-68px -13px' },
  long: { value: 'left', label: '左连接(给定条件，仅返回左表的行)', backgroundPosition: '-132px -13px' },
  int: { value: 'right', label: '右连接(给定条件，仅返回右表的行)', backgroundPosition: '-4px -13px' },
  double: { value: 'outer', label: '完全外连接(给定条件，仅返回两个表的全部行)', backgroundPosition: '-196px -13px' }
};


//
/**
 * 数据输出类型枚举
 */
export const paramDataTypeEnum = {
  string: { value: 'string', label: '字符型', defaultLength: 256, accuracy: -1, maxLength: 4000 },
  int: { value: 'int', label: '整型', defaultLength: -1, accuracy: -1 },
  float: { value: 'float', label: '浮点型', defaultLength: 38, accuracy: 2, maxLength: 38 },
  date: { value: 'date', label: '日期型', defaultLength: -1, accuracy: -1 }
};


export const spcCheckEnum = {
  string: { value: 'string', label: '一个点，距离中心线大于k个标准差', defaultLength: 256, accuracy: -1, maxLength: 4000 },
  int: { value: 'int', label: '数值型(INT)', defaultLength: -1, accuracy: -1 },
  float: { value: 'float', label: '数值型(FLOAT)', defaultLength: 38, accuracy: 2, maxLength: 38 },
  double: { value: 'double', label: '数值型(DOUBLE)', defaultLength: 38, accuracy: 2, maxLength: 38 },
  long: { value: 'long', label: '数值型(LONG)', defaultLength: 256, accuracy: -1 },
  date: { value: 'date', label: '日期型', defaultLength: -1, accuracy: -1 },
  text: { value: 'text', label: '文本型', defaultLength: -1, accuracy: -1 },
  vector: { value: 'vector', label: '向量', defaultLength: -1, accuracy: -1 },
  time: { value: 'time', label: '时间日期', defaultLength: -1, accuracy: -1 }
};

/**
 * 周枚举
 */
export const weekEnum = {
  Monday: { value: '1', label: '星期一' },
  Tuesday: { value: '2', label: '星期二' },
  Wednesday: { value: '3', label: '星期三' },
  Thursday: { value: '4', label: '星期四' },
  Friday: { value: '5', label: '星期五' },
  Saturday: { value: '6', label: '星期六' },
  Sunday: { value: '7', label: '星期天' }
};

/**
 * 调度优先级
 */
export const priorityEnum = {
  high: { value: '1', label: '高' },
  medium: { value: '2', label: '中' },
  low: { value: '3', label: '低' }
};

/**
 * 调度状态
 */
export const jobStatusEnum = {
  NONE: { value: 'NONE', label: '--' },
  NORMAL: { value: 'NORMAL', label: '运行' },
  PAUSED: { value: 'PAUSED', label: '暂停' },
  COMPLETE: { value: 'COMPLETE', label: '结束' },
  ERROR: { value: 'ERROR', label: '失败' },
  BLOCKED: { value: 'BLOCKED', label: '阻塞' }
};

/**
 * 数据权限-规则满足类型
 */
export const ruleFilterTypesEnum = {
  ORG: { value: 'ORG', label: '固定组织机构' },
  USER: { value: 'USER', label: '用户信息' },
  CUSTOM: { value: 'CUSTOM', label: '自定义' }
};
/**
 * 数据权限-规则过滤操作
 */
export const ruleOperTypesEnum = {
  EQUAL: { value: '=', label: '相等' },
  INCLUDE: { value: 'IN', label: '包含' },
  LIKE: { value: 'LIKE', label: '模糊' }
};

/**
 * 文件上传类型
 */
export const fileTypesEnum = {
  CSV: { value: 'csv', label: 'CSV' },
  TSV: { value: 'tsv', label: 'TSV' },
  DAT: { value: 'dat', label: 'DAT' },
  TXT: { value: 'txt', label: 'TXT' },
  XLS: { value: 'xls', label: 'XLS' },
  XLSX: { value: 'xlsx', label: 'XLSX' },
  MDB: { value: 'mdb', label: 'MDB' },
  ACCDB: { value: 'accdb', label: 'ACCDB' },
  DBF: { value: 'dbf', label: 'DBF' },
  ODB: { value: 'odb', label: 'ODB' },
  XML: { value: 'xml', label: 'XML' },
  JSON: { value: 'json', label: 'JSON' },
  JAR: { value: 'jar', label: 'JAR' },
  HTML: { value: 'html', label: 'HTML' },
  EBC: { value: 'ebc', label: 'EBC' }
};

export const enumList = function(enums){
  return Object.keys(enums).map(e => {
    return enums[e];
  });
};

export const enumItem = function(enums, value){
  const itemKey = Object.keys(enums).find(e => `${enums[e].value}` === `${value}`);
  if (itemKey) {
    return enums[itemKey] || {};
  }
  return {};
};


export default {
  QueryOperatorEnum,
  columnTypesEnum,
  tableTypesEnum,
  roleSettingEnum,
  flowRunStatusEnum,
  insightDataCategoryEnum,
  insightCategoryEnum,
  pointTypes,
  stringConvertModeEnum,
  numberConvertModeEnum,
  dateConvertModeEnum,
  subDateEnum,
  dateFormatEnum,
  dateConnModeEnum,
  dataTypeEnum,
  paramDataTypeEnum,
  spcCheckEnum,
  spcRulesEnum,
  weekEnum,
  priorityEnum,
  jobStatusEnum,
  ruleFilterTypesEnum,
  ruleOperTypesEnum,
  fileTypesEnum,
  JsJComparisonOperatorsEnum,
  portTypeEnum,
  enumList,
  enumItem
};

