import * as endConf from 'amos-processor/lib/config/endconf';
import completeSecurityUrl, { completeSecurityWsUrl } from 'amos-security/lib/consts/securityUrl';

const completePrefix = endConf.completePrefix;

const securityBaseURI = endConf.securityBaseURI;
const AmosConfig = endConf.AmosConfig;
const securityBaseWsURI = AmosConfig.wsURI.securityBaseURI;

const maasURI = AmosConfig.httpURI.maasURI;
const mockURI = AmosConfig.httpURI.baseURI;
const fileURI = AmosConfig.httpURI.fileURI;
const baseURI = AmosConfig.httpURI.baseURI;
const picURI = AmosConfig.httpURI.picURI;
const ureportURI = AmosConfig.httpURI.ureportURI;
const preControl = AmosConfig.httpURI.baseURI;

const secExVerson = 'v1';
const securityUrlWithVersion = `${securityBaseURI}${secExVerson}`;

export const SecurityUrl = completeSecurityUrl(securityBaseURI);
export const SecurityWsUrl = completeSecurityWsUrl(securityBaseWsURI);
export const XJBaseURI = baseURI;
export const PICURI = picURI;
export const UREPORTURI = ureportURI;
export const secExtUrl = {
  //*************************************
  //  op 内置接口url
  //*************************************
  opMenusUrl: completePrefix(securityBaseURI, 'permissionItem/allPermission-tree'),
  opSearchMenusUrl: completePrefix(securityBaseURI, 'permissionItem/searchPermission-tree?nodeName={nodeName}&type={type}'),
  orgManageTreeUrl: completePrefix(securityBaseURI, 'company/manage-tree'), //组织机构树
  allRoleUrl: completePrefix(securityBaseURI, 'role/all-roles'), //所有角色

  // 新权限接口

  //systemMenusUrl: completePrefix(securityBaseURI, `${secExVerson}/permission/tree/menu?code={code}&userId={userId}`), // 获取当前系统所有菜单
  systemMenusUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/permission/tree`), // 获取当前系统所有菜单(新)

  loginUrl: completePrefix(securityBaseURI, `${secExVerson}/system/login`), // 登陆获取accessToken

  // 获取指定菜单下授权的按钮权限 get
  buttonAuthUrl: completePrefix(securityBaseURI, 'privilege/v1/permission/map/user/button?menuAgent={menuAgent}&path={path}&roleSeq={roleSeq}'),

  permissionsCompanyUrl: completePrefix(securityBaseURI, `${secExVerson}/user/me`), // 登陆用户权限所有公司
  // permissionsMenusUrl: completePrefix(securityBaseURI, `${secExVerson}/permission/tree/curruser`), // 登陆用户系统权限菜单
  //permissionsMenusUrl: completePrefix(securityUrlWithVersion, '/permission/tree/{roleSeq}'), // 登陆用户系统权限菜单---TODO新版待修改
  permissionsMenusUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/permission/tree/role?roleSeq={roleSeq}`), // 登陆用户系统权限菜单---TODO新版待修改(新)

  loginOutUrl: completePrefix(securityBaseURI, `${secExVerson}/system/loginOutr`), // 登陆用户系统权限菜单

  curUserMenusUrl: completePrefix(securityBaseURI, 'privilege/v1/permission/tree/me'), //查询当前用户菜单
  curRoleMenusUrl: completePrefix(securityBaseURI, 'privilege/v1/permission/tree/role?roleSeq={roleSeq}'), //查询当前角色菜单树
  curUserInfoUrl: completePrefix(securityBaseURI, 'privilege/v1/agencyuser/me'), //查询当前用户信息
  //searchCompanysUrl: completePrefix(securityBaseURI,'/privilege/v1/company/tree'),//查询公司
  searchCompanysUrl: completePrefix(securityBaseURI, `${secExVerson}/user/me`), // 获取当前登陆用户信息

  searchDepartmentUrl: completePrefix(securityBaseURI, '/privilege/v1/department/tree?companySeq={companySeq}'), //查询部门
  searchRolesUrl: completePrefix(securityBaseURI, 'privilege/v1/role/list'), //查询角色

  //currentUserUrl: completePrefix(securityBaseURI, `${secExVerson}/user/me`), // 获取当前登陆用户信息
  currentUserUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/agencyuser/me`) // 获取当前登陆用户信息(新)
};

export const filePrifixUrl = url => completePrefix(fileURI, url);

export const fileSystemUrl = (url, defaultUrl) => {
  return url ? completePrefix(fileURI, url) : defaultUrl;
};

export const patrolUrls = {
  regionSelectUrl: completePrefix(baseURI, 'safe/save/curCompany'), //保存登录用户信息

  inputItemTablesUrl: completePrefix(baseURI, 'api/inputItem/queryItemByPage?pageNumber={page}&pageSize={size}'),
  inputItemBatchDelUrl: completePrefix(baseURI, 'api/inputItem/batchDelItem?itemIDs={ids}'),
  inputItemSaveAsUrl: completePrefix(baseURI, 'api/inputItem/saveAs?itemIDs={ids}'),
  inputItemSaveUrl: completePrefix(baseURI, 'api/inputItem/addItem'),
  pointListGetUrl: completePrefix(baseURI, 'api/point/list?pageNumber={page}&pageSize={size}'), // 获取巡检点列表
  pointSaveAsUrl: completePrefix(baseURI, 'api/point/saveAs?ids={ids}'), // 点另存为
  pointDeleteUrl: completePrefix(baseURI, 'api/point/deletePoint?ids={ids}'), // 删除点
  routeListGetUrl: completePrefix(baseURI, 'api/route/list'), //获取路线
  inputItemDetailUrl: completePrefix(baseURI, 'api/inputItem/queryItem?itemID={itemID}'),
  planInfoTablesUrl: completePrefix(baseURI, 'api/plan/list?pageNumber={page}&pageSize={size}'),
  pointAddUrl: completePrefix(baseURI, 'api/point/addPoint'), // 新增点
  planSaveUrl: completePrefix(baseURI, 'api/plan/addPlan'),
  deptByOrgCodeUrl: completePrefix(baseURI, 'api/group/queryDept'),
  deptByOrgCodeUrl1: completePrefix(baseURI, 'api/group/queryDept1'),
  deptByOrgCodeUrl2: completePrefix(baseURI, 'api/group/queryDept2'),
  userInfoByDeptIdUrl: completePrefix(baseURI, 'api/user/queryDeptUser?deptId={deptId}'),
  userTreeGetByCompanyIdUrl: completePrefix(securityBaseURI, '/user/user-tree/{companyId}?roleType={roleType}'), // 获取公司下属所有部门及部门下的用户构建的树(可指定角色类型)
  taskPageUrl: completePrefix(baseURI, 'api/task/queryTaskByPage?pageNumber={page}&pageSize={size}'),
  taskBatchDelUrl: completePrefix(baseURI, 'api/task/batchDelTask?taskIDs={ids}'),
  taskHandleUrl: completePrefix(baseURI, 'api/task/handleTask?taskIds={ids}&status={status}'),
  taskDetailUrl: completePrefix(baseURI, 'api/task/queryTask?taskID={id}'),
  taskAddUrl: completePrefix(baseURI, 'api/task/addTask'),
  deptUserTreeUrl: completePrefix(baseURI, 'api/user/queryDeptUserTree'),

  deptUserTreeUrl2: completePrefix(baseURI, 'api/user/queryDeptUserTree1'),
  taskFeedbackTaskUrl: completePrefix(baseURI, 'api/task/feedbackTask'),
  routePageUrl: completePrefix(baseURI, 'api/route/list?pageNumber={page}&pageSize={size}'),
  routeBatchDelUrl: completePrefix(baseURI, 'api/route/deleteRoute?routeIds={ids}'),
  routeAddUrl: completePrefix(baseURI, 'api/route/addRoute'),
  routeDetailUrl: completePrefix(baseURI, 'api/route/queryRouteById/{id}'),
  routeUpdateUrl: completePrefix(baseURI, 'api/route/updateRoute'),
  routePointPageUrl: completePrefix(baseURI, 'api/route/listRoutePoint?routeId={id}&pageNumber={page}&pageSize={size}'),
  planDetByPlanIdUrl: completePrefix(baseURI, 'api/plan/detail/{planId}'),
  routePointBatchDelUrl: completePrefix(baseURI, 'api/route/deleteRoutePoint?pointIds={pointIds}&routeId={routeId}'),
  RoutePointMigrateUrl: completePrefix(baseURI, 'api/route/migrateRoutePoint?sourceRouteId={sourceRouteId}&pointIds={pointIds}&targetRouteId={targetRouteId}'),
  routeUrl: completePrefix(baseURI, 'api/route/All'),
  routePointsAuthUrl: completePrefix(baseURI, 'api/point/queryPoints?code={code}&name={name}'),
  routePointAddUrl: completePrefix(baseURI, 'api/route/addRoutePoint?routeId={routeId}&pointIds={pointIds}'),
  pointInputItemUrl: completePrefix(baseURI, 'api/point/queryPointInputItem?pointId={pointId}'), // pointInputItemUrl
  inputItemQueryByConditionUrl: completePrefix(baseURI, 'api/inputItem/queryItemByCondition'),
  inputItemQueryByConditionUrl1: completePrefix(baseURI, 'api/inputItem/queryItemByCondition1'),
  planSaveAsUrl: completePrefix(baseURI, 'api/plan/saveAs'),
  planBatchDetUrl: completePrefix(baseURI, 'api/plan/deletePlanById'),
  endplan: completePrefix(baseURI, 'api/planTask/endPlan'),
  startplan: completePrefix(baseURI, 'api/planTask/startplan'),
  planTaskTablesUrl: completePrefix(baseURI, 'api/planTask/list?pageNumber={page}&pageSize={size}'),
  reGenplanTaskUrl: completePrefix(baseURI, 'api/planTask/regenPlanTask'),
  deleteplanTaskUrl: completePrefix(baseURI, 'api/planTask/deletePlanTask'),
  pointQueryByIdUrl: completePrefix(baseURI, 'api/point/queryPointById/{pointId}'),
  planInfoNoPageUrl: completePrefix(baseURI, 'api/plan/queryPlanByOrgCode'),
  taskPrintUrl: completePrefix(baseURI, 'api/task/printTask?taskID={taskID}'),
  //  pointInputItemQueryUrl: completePrefix(baseURI, 'api/point/queryPointInputItem?pointId={pointId}'), //  pointInputItemUrl
  pointClassifyWithInputItemQueryUrl: completePrefix(baseURI, 'api/point/queryPointClassifyWithInputItem?pointId={pointId}'),
  routePointInputItemUrl: completePrefix(baseURI, 'api/route/listRoutePointInputItem'),
  routePointInputItemUpdateUrl: completePrefix(baseURI, '/api/route/updateRoutePointInputItem?routeId={routeId}&pointId={pointId}&inputItemIds={inputItemIds}'),
  companysUrl: completePrefix(baseURI, 'api/group/queryAuthCompanyLeaves'),
  //saveSelectCompanyUrl: completePrefix(baseURI, 'safe/save/curCompany/{orgCode}'),
  //new
  saveSelectCompanyUrl: completePrefix(baseURI, 'api/user/save/curCompany'),
  checkTablesUrl: completePrefix(baseURI, 'api/check/list?pageNumber={page}&pageSize={size}'),
  pointUpdateUrl: completePrefix(baseURI, 'api/point/updatePoint'),
  checkBatchDetUrl: completePrefix(baseURI, 'api/check/deleteCheckById'),
  catalogTreeUrl: completePrefix(baseURI, 'api/catalogTree/getCatalogTree'),
  catalogTreeSaveUrl: completePrefix(baseURI, 'api/catalogTree/addCatalogTree'),
  catalogTreeBatDelUrl: completePrefix(baseURI, 'api/catalogTree/deleteCatalogTreeById'),
  catalogTreeListUrl: completePrefix(baseURI, 'api/catalogTree/list?pageNumber={page}&pageSize={size}'),
  catalogTreeDetByIdUrl: completePrefix(baseURI, 'api/catalogTree/catalogTreeDetById/{id}'),
  forwardTaskUrl: completePrefix(baseURI, 'api/task/forwardTask?userId={userId}&taskID={taskID}'),
  checkDetailUrl: completePrefix(baseURI, 'api/check/queryCheckInfo?checkId={checkId}'),
  exportCheckRecordUrl: completePrefix(baseURI, 'api/check/export'),
  exportCheckRecordImgsUrl: completePrefix(baseURI, 'api/check/exportImgs'),
  checkRecordImgsExportByIdsUrl: completePrefix(baseURI, 'api/check/exportImgsByIds?ids={ids}'),
  exportSelectRecordUrl: completePrefix(baseURI, 'api/check/exportSelectRecord?ids={ids}'),
  exportListPointUrl: completePrefix(baseURI, 'api/point/exportListPoint?exportType={exportType}'),
  exportSelectedPointListUrl: completePrefix(baseURI, 'api/point/exportListPointByIds?ids={ids}&exportType={exportType}'),
  exportPointTemplateUrl: completePrefix(baseURI, 'api/point/exportTemplate'),
  importPointUrl: completePrefix(baseURI, 'api/point/import'),
  reportPlanTaskUrl: completePrefix(baseURI, 'api/planTask/reportPlanTask'),
  exportSelectPlanTaskUrl: completePrefix(baseURI, 'api/planTask/exportSelectPlanTask?ids={ids}'),
  pointNoQueryUrl: completePrefix(baseURI, 'api/point/queryPointNo/{pointId}'),
  itemNoQueryUrl: completePrefix(baseURI, 'api/inputItem/queryItemNo/{itemId}'),
  exchangeOrderNumberUrl: completePrefix(baseURI, '/api/route/exchangeOrderNumber?src={src}&target={target}'),
  //消息提醒
  getNewsListUrl: completePrefix(baseURI, 'api/msgSubscribe/list?pageNumber={page}&pageSize={size}'), //分页获取消息提醒集合
  sendNewsUrl: completePrefix(baseURI, 'api/msgSubscribe/noticePublish'), //发送消息通知
  repeatNewsUrl: completePrefix(baseURI, ''), //重发消息
  deleteNewsUrl: completePrefix(baseURI, ''), //删除消息提醒
  newsTypeListUrl: completePrefix(baseURI, 'api/msgSubscribe/MsgType'), //获取消息类型集合
  newsPersonDataUrl: completePrefix(baseURI, 'api/user/queryDeptUserTree'), //获取消息接受人员
  newsPersonDataUrl2: completePrefix(baseURI, 'api/user/queryDeptUserTree1'), //获取消息接受人员
  newsPersonDataUrl3: completePrefix(baseURI, 'api/user/queryDeptUserTree2'), //获取消息接受人员
  //查询统计
  completionSituationUrl: completePrefix(baseURI, 'api/task/report/{statistical}?startDate={startDate}&endDate={endDate}&planId={planId}&routeId={routeId}'),
  completionSituationExportUrl: completePrefix(
    baseURI,
    'api/excel/task/{statistical}?startDate={startDate}&endDate={endDate}&planId={planId}&routeId={routeId}'
  ), //巡检完成情况月报表-表格导出
  caliberListUrl: completePrefix(baseURI, 'api/common/checkStatisticsType'), //巡检完成情况月报表-获取统计口径集合
  planListUrl: completePrefix(baseURI, 'api/plan/queryPlanList'), //巡检完成情况月报表-获取所属计划集合
  lineListUrl: completePrefix(baseURI, 'api/route/routeList'), //巡检完成情况月报表-所属线路集合

  executeStateListUrl: completePrefix(baseURI, 'api/common/planTaskExecution'), //巡检情况统计分析-执行情况集合
  inspectionSituationListUrl: completePrefix(baseURI, 'api/check/statisticalAnalysis'), //巡检情况统计分析-表格
  inspectionSituationExportUrl: completePrefix(baseURI, 'api/check/exportStatisticalAnalysis'), //巡检情况统计分析-表格导出
  taskArrangementListUrl: completePrefix(baseURI, 'api/task/getStatisticsData'), //任务安排统计分析-表格
  taskArrangementExportUrl: completePrefix(baseURI, 'api/task/exportStatisticsData'), //任务安排统计分析-表格导出
  taskCaliberListUrl: completePrefix(baseURI, 'api/common/taskgetStatisticsType'), //任务安排统计分析-获取任务统计口径集合
  personStatisticsUrl: completePrefix(baseURI, 'api/task/report/comprehensive/user?startTime={startTime}&endTime={endTime}'), //人员综合统计分析-表格
  personStatisticsExportUrl: completePrefix(baseURI, 'api/excel/comprehensive/user?startTime={startTime}&endTime={endTime}'), //人员综合统计分析-表格导出
  monthSituationUrl: completePrefix(baseURI, 'api/check/statisticalByMonth'), //月度巡检情况-表格
  monthSituationExportUrl: completePrefix(baseURI, 'api/check/exportStatisticalByMonth'), //月度巡检情况-表格导出
  daySituationExportUrl: completePrefix(baseURI, 'api/check/exportByDept'), //每日巡检情况-表格导出

  homeNumberUrl: completePrefix(baseURI, 'api/home/overviewData'), //巡检首页-获取公司名、巡检点数、完成/计划、累计巡检次数、未完/已完任务数和巡检点数
  homeChartUrl: completePrefix(baseURI, 'api/home/getCheckData'), //巡检首页-获取12日内 实际巡检、计划巡检和漏检次数每天的数值
  currentCompanyUrl: completePrefix(baseURI, 'api/user/queryLoginUserAndCompany'), //当前系统公司信息
  SpecCheckDetailUrl: completePrefix(baseURI, 'api/spc/check-detail'), //查询检查项详情
  SpecCheckInputById: completePrefix(baseURI, 'api/spc/check-input'), //根据ID查询巡检记录项
  searchCheckShortUrl: completePrefix(baseURI, 'api/check/getCheckPic?checkId={checkId}&checkInputId={checkInputId}&classifyId={classifyId}'), //根据检查项ID和检查项输入ID查询图片
  riskLevelUrl: completePrefix(baseURI, 'api/user/listDictionaryByDictCode/FXDJ_TYPE')
};

/**
 * 风险预控系统接口
 */
export const preControlUrls = {
  riskSourceSecondLevelUrl: completePrefix(preControl, 'api/risksource/riskSourceSecondLevel') //获取二级风险源信息（用户巡检点风险区域选择）
};
