import classnames from 'classnames';
import { trim } from 'amos-tool';
//主题模版文件地址
export const THEMES_TEMPLATE = '/static/css/app.css';


const labelConst = 8;
const wrapperConst = 14;

const formItemLayout = function(label = labelConst, wrapper = wrapperConst){
  return {
    labelCol: {
      xs: { span: 24 },
      sm: { span: label },
      className: 'colspanlab'
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: wrapper },
      className: 'colspan'
    }
  };
};

const formLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: labelConst },
    className: 'colspanlab'
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: wrapperConst },
    className: 'colspan'
  }
};

export const formRule = {
  LEN_32: 32,
  LEN_255: 255,
  normalText: ({ min, max, message, required }) => {
    return [
      { required, message: '必填项' },
      {
        validator: (rules, value, callback) => {
          value = trim(value || '');
          if (value) {
            let len = value.length;
            if (!isEmpty(min) && min > len) {
              callback(new Error(`不能小于${min}位`));
              return;
            }
            if (!isEmpty(max) && len > max) {
              callback(new Error(`不能大于${max}位`));
              return;
            }
            callback();
          } else {
            if (required) {
              callback(new Error(message));
            } else {
              callback();
            }
          }
        }
      }
    ];
  },
  keyCodeText: ({ min, max, message, required, regExp }) => {
    regExp = regExp ? regExp : '^[0-9a-zA-Z_]{1,}$';
    let reg = new RegExp(regExp);
    return [
      { required, message: '必填项' },
      {
        validator: (rules, value, callback) => {
          value = trim(value || '');
          if (value) {
            let len = value.length;
            if (!isEmpty(min) && min > len) {
              callback(new Error(`不能小于${min}位`));
              return;
            }
            if (!isEmpty(max) && len > max) {
              callback(new Error(`不能大于${max}位`));
              return;
            }
            if (!reg.test(value)) {
              callback(new Error(message || '只能输入字母数字和下滑线'));
              return;
            }
            callback();
          } else {
            if (required) {
              callback(new Error('必填项'));
            } else {
              callback();
            }
          }
        }
      }
    ];
  }
};

const isEmpty = (value) => value === null || value === undefined;

const wrapperMax = 24;

for (let i = 0; i <= wrapperMax; i++) {
  formLayout[`${i}`] = formItemLayout(...[i, wrapperMax - i]);
}

const itemLayout = (width, label, other) => {
  return classnames(
    `item-${width}`,
    `item-label-${label}`,
    other
  );
};

export {
  formItemLayout,
  formLayout,
  itemLayout
};
