// @author ilex.h
import React from 'react';
import AsyncLoader from 'ray-code-split';

import parsePlugin from './parsePlugin';

const AsyncDepartment = (props) => <AsyncLoader load={import('amos-security/lib/view/department')} componentProps={props} />;
const AsyncMenu = (props) => <AsyncLoader load={import('amos-security/lib/view/menu')} componentProps={props} />;
const AsyncRole = (props) => <AsyncLoader load={import('amos-security/lib/view/role')} componentProps={props} />;
const AsyncUser = (props) => <AsyncLoader load={import('amos-security/lib/view/user')} componentProps={props} />;
const AsyncSystemDic = (props) => <AsyncLoader load={import('amos-security/lib/view/systemdic')} componentProps={props} />;
const AsyncCompany = (props) => <AsyncLoader load={import('amos-security/lib/view/company')} componentProps={props} />;
const AsyncUniversalContainer = (props) => <AsyncLoader load={import('amos-security/lib/view/UniversalContainer')} componentProps={props} />;
const AsyncUserInfo = (props) => <AsyncLoader load={import('amos-security/lib/view/userInfo')} componentProps={props} />;
// const AsyncOutter = (props) => <AsyncLoader load={import('amos-security/lib/view/login/FreeLogin')} componentProps={props} />;


const AsyncLogin = (props) => <AsyncLoader load={import('./../view/login')} componentProps={props} />;
const AsyncRootView = (props) => <AsyncLoader load={import('./../view/mainframe')} componentProps={props} />;
const AsyncRegionList = props => <AsyncLoader load={import('./../view/region')} componentProps={props} />;
const AsyncOutter = props => <AsyncLoader load={import('./../view/outter')} componentProps={props} />;

//巡检
const AsyncPatrolHome = (props) => <AsyncLoader load={import('./../view/patrol/home')} componentProps={props} />;
const AsyncInputItem = (props) => <AsyncLoader load={import('./../view/patrol/inputItem')} componentProps={props} />;
const AsyncPoint = (props) => <AsyncLoader load={import('./../view/patrol/point')} componentProps={props} />;
const AsyncPlan = (props) => <AsyncLoader load={import('./../view/patrol/plan')} componentProps={props} />;
const AsyncTask = (props) => <AsyncLoader load={import('./../view/patrol/task')} componentProps={props} />;
const AsyncRoute = (props) => <AsyncLoader load={import('./../view/patrol/routeNew')} componentProps={props} />;
const AsyncCheck = (props) => <AsyncLoader load={import('./../view/patrol/check')} componentProps={props} />;
const AsyncCatalogTree = (props) => <AsyncLoader load={import('./../view/patrol/catalogTree')} componentProps={props} />;
const AsyncNews = (props) => <AsyncLoader load={import('./../view/patrol/news')} componentProps={props} />;
const AsyncStatistics = (props) => <AsyncLoader load={import('./../view/patrol/statistics')} componentProps={props} />;

const AsyncAutoLogin = props => <AsyncLoader load={import('./../view/autoLogin/AutoLogin')} componentProps={props} />;

const EmptyPage = (props) => <div>空页面</div>;

const Routes = {
  ...parsePlugin(),

  main: AsyncRootView,
  config: AsyncUniversalContainer,
  company: AsyncCompany,
  department: AsyncDepartment,
  menu: AsyncMenu,
  role: AsyncRole,
  user: AsyncUser,
  systemdic: AsyncSystemDic,
  //巡检
  patrol: AsyncPatrolHome,
  inputitem: AsyncInputItem,
  point: AsyncPoint,
  plan: AsyncPlan,
  task: AsyncTask,
  route: AsyncRoute,
  check: AsyncCheck,
  catalogtree: AsyncCatalogTree,
  news: AsyncNews,
  statistics: AsyncStatistics,
  
  autologin: AsyncAutoLogin,
};

const pageCompontent = (key) => {
  return Routes[key] || EmptyPage;
};

export {
  AsyncLogin,
  AsyncRootView,
  AsyncUserInfo,
  AsyncOutter,
  AsyncRegionList
};

export default pageCompontent;
