import { combineRoutes } from 'amos-pluggable';
import { parseCusotmRoutes } from './parsePlugin';

import TextInputItem from './../view/patrol/inputItem/TextInputItem';
import NumberInputItem from './../view/patrol/inputItem/NumberInputItem';
import choiceInputItem from './../view/patrol/inputItem/choiceInputItem';

import textInputItemxq from './../view/patrol/inputItem/TextInputItemxq';
import NumberInputItemxq from './../view/patrol/inputItem/NumberInputItemxq';
import choiceInputItemxq from './../view/patrol/inputItem/choiceInputItemxq';



import Point from './../view/patrol/point/PointView';
import PointInfo from '../view/patrol/point/PointInfo';
import PlanInput from './../view/patrol/plan/PlanInput';

import PlanInputxq from './../view/patrol/plan/PlanInputxq';
import NewTask from './../view/patrol/task/newTask';
import DetailTask from './../view/patrol/task/taskDetail';
import newRoute from './../view/patrol/route/newRoute';
import RouteInfo from './../view/patrol/routeNew/RouteInfo';

import RouteInfoxq from './../view/patrol/routeNew/RouteInfoxq';

import routePoint from './../view/patrol/route/routePoint';
import PointInfoEdit from './../view/patrol/point/PointInfoEdit';
import PointInfoEditxq from './../view/patrol/point/PointInfoEditxq';
import planTask from './../view/patrol/plan/planTask';
import catalogTreeInput from './../view/patrol/catalogTree/CatalogTreeInput';
import ImportPoint from './../view/patrol/point/importPoint';

import NewsAdd from './../view/patrol/news/NewsAdd';
//查询统计子页面
import CompletionSituation from './../view/patrol/statistics/completionSituation';
import InspectionSituation from './../view/patrol/statistics/inspectionSituation';
import TaskArrangement from './../view/patrol/statistics/taskArrangement';
import PersonStatistics from './../view/patrol/statistics/personstatistics';
import MonthSituation from './../view/patrol/statistics/monthSituation';
import CheckDetail from './../view/patrol/check/checkDetail';

/**
 * 系统自定义路由
 */
const customRoutes = [
  ...parseCusotmRoutes().filter(e => e.parent !== 'main'),
  { path: '/main/patrol/textInputItem', parent: 'patrol', component: TextInputItem },
  { path: '/main/patrol/numberInputItem', parent: 'patrol', component: NumberInputItem },
  { path: '/main/patrol/choiceInputItem', parent: 'patrol', component: choiceInputItem },
 
  { path: '/main/patrol/textInputItemxq', parent: 'patrol', component: textInputItemxq },
  { path: '/main/patrol/numberInputItemxq', parent: 'patrol', component: NumberInputItemxq },
  { path: '/main/patrol/choiceInputItemxq', parent: 'patrol', component: choiceInputItemxq },


  { path: '/main/patrol/point', parent: 'patrol', component: Point },
  { path: '/main/patrol/pointInfo', parent: 'patrol', component: PointInfo },
  { path: '/main/patrol/newTask', parent: 'patrol', component: NewTask },
  { path: '/main/patrol/detailTask', parent: 'patrol', component: DetailTask },
  { path: '/main/patrol/planInput', parent: 'patrol', component: PlanInput },
  { path: '/main/patrol/planInputxq', parent: 'patrol', component: PlanInputxq },

  { path: '/main/patrol/newRoute', parent: 'patrol', component: newRoute },
  { path: '/main/patrol/editRoute', parent: 'patrol', component: RouteInfo },
  { path: '/main/patrol/editRoutexq', parent: 'patrol', component: RouteInfoxq },

  { path: '/main/patrol/routePoint', parent: 'patrol', component: routePoint },
  { path: '/main/patrol/pointInfoEditxq', parent: 'patrol', component: PointInfoEditxq },
  { path: '/main/patrol/pointInfoEdit', parent: 'patrol', component: PointInfoEdit},
  { path: '/main/patrol/plan/planTask', parent: 'patrol', component: planTask },
  { path: '/main/patrol/catalogTreeInput', parent: 'patrol', component: catalogTreeInput },
  { path: '/main/patrol/importPoint', parent: 'patrol', component: ImportPoint },
  { path: 'newsadd', parent: 'patrol', component: NewsAdd },
  { path: 'completionsituation', parent: 'patrol', component: CompletionSituation },
  { path: 'inspectionSituation', parent: 'patrol', component: InspectionSituation },
  { path: 'taskArrangement', parent: 'patrol', component: TaskArrangement },
  { path: 'personStatistics', parent: 'patrol', component: PersonStatistics },
  { path: 'monthSituation', parent: 'patrol', component: MonthSituation }, 
  { path: '/main/patrol/checkDetail', parent: 'patrol', component: CheckDetail }
];


export const customRoutesMain = [
  ...parseCusotmRoutes().filter(e => e.parent === 'main')
];
/**
 * path mapping
 *
 * import { parseText } from 'amos-tool';
 * const stage = parseText(pathMapping.stage, { objkey });
 */
export const pathMapping = {

  //巡检
  inputitem: '/main/patrol/inputitem',
  point: '/main/patrol/point',
  plan: '/main/patrol/plan',
  textInputItem: '/main/patrol/textInputItem',
  numberInputItem: '/main/patrol/numberInputItem',
  choiceInputItem: '/main/patrol/choiceInputItem',

  textInputItemxq: '/main/patrol/textInputItemxq',
  numberInputItemxq: '/main/patrol/numberInputItemxq',
  choiceInputItemxq: '/main/patrol/choiceInputItemxq',


  pointInfo: '/main/patrol/pointInfo',
  planInput: '/main/patrol/planInput',
  planInputxq: '/main/patrol/planInputxq',

  tasktask: '/main/patrol/task',
  newTask: '/main/patrol/newTask',
  detailTask: '/main/patrol/detailTask',
  newRoute: '/main/patrol/newRoute',
  editRoute: '/main/patrol/editRoute',
  editRoutexq: '/main/patrol/editRoutexq',

  route: '/main/patrol/route',
  routePoint: '/main/patrol/routePoint',
  pointInfoEdit: '/main/patrol/pointInfoEdit',
  pointInfoEditxq: '/main/patrol/pointInfoEditxq',
  planTask: '/main/patrol/plan/planTask',
  check: '/main/patrol/check',
  catalogTree: '/main/patrol/catalogtree',
  catalogTreeInput: '/main/patrol/catalogTreeInput',
  importPoint: '/main/patrol/importPoint',
  news: '/main/patrol/news',
  newsAdd: '/main/patrol/newsadd',
  statistics: '/main/patrol/statistics',
  completionsituation: '/main/patrol/completionsituation',
  inspectionSituation: '/main/patrol/inspectionSituation',
  taskArrangement: '/main/patrol/taskArrangement',
  personStatistics: '/main/patrol/personStatistics',
  monthSituation: '/main/patrol/monthSituation',
  checkDetail: '/main/patrol/checkDetail'
};
/**
 *  将自定义路由添加到主路由上
 * @param {*} mainRoutes
 */
const addCustomRoutes = (mainRoutes) => combineRoutes(mainRoutes, customRoutes);

export default addCustomRoutes;
