import React from 'react';
import {
  Department,
  Menu,
  Role,
  User,
  SystemDic,
  Company,
  UniversalContainer,
  UserInfo
} from 'amos-security/lib';
//import Outter from 'amos-security/lib/view/login/FreeLogin';
import Outter from '../view/outter';

import parsePlugin from './parsePlugin';

import PluginCore from './../view/mainframe/PluginCore';


import Login from './../view/login';
import RootView from './../view/mainframe';
import RegionList from './../view/region';

//巡检业务
import PatrolHome from './../view/patrol/home';
import InputItem from './../view/patrol/inputItem';
import Plan from './../view/patrol/plan';
import Point from './../view/patrol/point';
import Route from './../view/patrol/routeNew';
import Task from './../view/patrol/task';
import Check from './../view/patrol/check';
import CatalogTree from './../view/patrol/catalogTree';
import News from './../view/patrol/news';
import Statistics from './../view/patrol/statistics';


const EmptyPage = (props) => <div>空页面</div>;


const Routes = {
  ...parsePlugin(),

  main: RootView,


  pluginCore: PluginCore,
  company: Company,
  department: Department,
  menu: Menu,
  role: Role,
  systemdic: SystemDic,
  user: User,
  config: UniversalContainer,

  //巡检业务
  patrol: PatrolHome,
  inputitem: InputItem,
  plan: Plan,
  point: Point,
  route: Route,
  task: Task,
  check: Check,
  catalogtree: CatalogTree,
  news: News,
  statistics: Statistics
};

const pageCompontent = (key) => {
  return Routes[key] || EmptyPage;
};

export {
  Login,
  RootView,
  UserInfo,
  Outter,
  RegionList
};

export default pageCompontent;
