import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { patrolUrls } from './../consts/urlConsts';
import { commonGet, commonPost, commonDelete } from './../utils/request';

/**
 * 分页获取消息提醒集合
 */
export const getNewsListAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.getNewsListUrl, { page, size }), filter);
};

/**
 * 发送消息通知
 */
export const sendNewsAction = (data) => {
  return commonPost(patrolUrls.sendNewsUrl, data);
};

/**
 * 重发消息
 */
export const repeatNewsAction = () => {
  return commonGet(patrolUrls.repeatNewsUrl);
};

/**
 * 删除消息提醒
 */
export const deleteNewsAction = (ids) => {
  return commonDelete(patrolUrls.deleteNewsUrl, ids);
};

/**
 * 获取消息类型集合
 */
export const newsTypeListAction = () => {
  return commonGet(patrolUrls.newsTypeListUrl);
};

/**
 * 获取消息接受人员
 */
export const newsPersonDataAction1 = () => {
  return commonGet(patrolUrls.newsPersonDataUrl3);
};
