import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { patrolUrls } from './../consts/urlConsts';
import { commonGet, commonPost, commonDelete, commonPut } from './../utils/request';

/**
 * 获取巡检点
 */
export const getPointListAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.pointListGetUrl, { page, size }), filter);
};

/**
 * 点另存为
 */
export const saveAsPointAction = (ids) => {
  return commonPost(formatUrl(patrolUrls.pointSaveAsUrl, { ids }));
};

/**
 * 删除点
 */
export const deletePointAction = (ids) => {
  return commonDelete(formatUrl(patrolUrls.pointDeleteUrl, { ids }));
};

/**
 * 添加点
 */
export const addPointAction = (point) => {
  return commonPost(patrolUrls.pointAddUrl, point);
};

/**
 * 根据ID查询点
 */
export const queryPointByIdAction = (pointId) => {
  return commonGet(formatUrl(patrolUrls.pointQueryByIdUrl, { pointId }));
};

/**
 * 根据ID查询点的巡检项
 */
export const queryPointInputItemAction = (pointId) => {
  return commonPost(formatUrl(patrolUrls.pointInputItemUrl, { pointId }));
};

/**
 * 根据ID查询点的分类及巡检项
 */
export const queryPointClassifyWithInputItemAction = (pointId) => {
  return commonPost(formatUrl(patrolUrls.pointClassifyWithInputItemQueryUrl, { pointId }));
};

/**
 * 更新点
 */
export const updatePointAction = (point) => {
  return commonPut(patrolUrls.pointUpdateUrl, point);
};

/**
 * 根据ID查询点
 */
export const queryAllPointNoAction = (pointId) => {
  return commonGet(formatUrl(patrolUrls.pointNoQueryUrl, { pointId }));
};

/**
 * 查询风险等级
 */
export const gerRiskLevel = (pointId) => {
  return commonGet(patrolUrls.riskLevelUrl);
};