import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { patrolUrls } from './../consts/urlConsts';
import { commonGet, commonPost, commonDelete } from './../utils/request';

/**
 * 获取巡检点
 */
export const getRouteListAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.routeListGetUrl, { page, size }), filter);
};

/**
 * 获取巡检路线点上的项
 */
export const getRoutePointInputItemAction = (body) => {
  return commonPost(formatUrl(patrolUrls.routePointInputItemUrl),body );
};

/**
 * 更新巡检路线点上的项
 */
export const updateRoutePointInputItemAction = (routeId, pointId, inputItemIds) => {
  return commonPost(formatUrl(patrolUrls.routePointInputItemUpdateUrl, { routeId, pointId, inputItemIds }));
};
