import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { secExtUrl } from './../consts/urlConsts';
import { commonGet, commonPost } from './../utils/request';
import { patrolUrls } from './../consts/urlConsts';
export const getCurrentUser = () => {
  return commonGet(secExtUrl.currentUserUrl);
};


export const regionSelectAction = (body) => {
  let url = formatUrl(patrolUrls.regionSelectUrl);
  return commonPost(url, body);
};


// export const getSystemAllMenu = (code, userId) => {
//   return commonGet(formatUrl(secExtUrl.systemMenusUrl, { code, userId }));
// };

export const getSystemAllMenu = () => {
  
  return commonGet(formatUrl(secExtUrl.systemMenusUrl));
};

export const login = (code, userId) => {
  return commonPost(formatUrl(secExtUrl.loginUrl), { code, userId });
};


export const getPermissionsCompany = () => {
  return commonGet(formatUrl(secExtUrl.systemMenusUrl));
};




// export const getPermissionsMenus = () => {
//   return commonGet(formatUrl(secExtUrl.permissionsMenusUrl));
// };

/**
 * 获取当前用户权限菜单
 * @param {*} roleSeq 角色Id
 */
export const getCurUserMenus = () => {
  return commonGet(formatUrl(secExtUrl.curUserMenusUrl));
};

/**
 * 获取用户信息
 */
export const currentUserAction = () => {
  return commonGet(secExtUrl.currentUserUrl);
};

/**
 * 根据角色获取菜单
 */
export const searchMenusByRoleAction = (roleSeq) => {
  return commonGet(formatUrl(secExtUrl.permissionsMenusUrl, { roleSeq }));
};