import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { patrolUrls } from './../consts/urlConsts';
import { commonGet, commonPost } from './../utils/request';

/**
 * 巡检完成情况月报表-表格
 */
export const completionSituationAction = (data) => {
  return commonGet(formatUrl(patrolUrls.completionSituationUrl, data));
};

/**
 * 巡检完成情况月报表-获取统计口径集合
 */
export const caliberListAction = (data) => {
  return commonGet(patrolUrls.caliberListUrl);
};

/**
 * 巡检完成情况月报表-获取所属计划集合
 */
export const planListAction = () => {
  return commonGet(patrolUrls.planListUrl);
};

/**
 * 巡检完成情况月报表-所属线路集合
 */
export const lineListAction = (ids) => {
  return commonGet(patrolUrls.lineListUrl);
};
/**
 * 巡检情况统计分析-执行情况集合
 */
export const executeStateListAction = () => {
  return commonGet(patrolUrls.executeStateListUrl);
};
/**
 * 巡检情况统计分析-表格
 */
export const inspectionSituationListAction = (filter) => {
  return commonPost(patrolUrls.inspectionSituationListUrl, filter);
};
/**
 * 任务安排统计分析-表格
 */
export const taskArrangementListAction = (filter) => {
  return commonPost(patrolUrls.taskArrangementListUrl, filter);
};

/**
 * 任务安排统计分析-获取任务统计口径集合
 */
export const taskCaliberListAction = (data) => {
  return commonGet(patrolUrls.taskCaliberListUrl);
};
/**
 * 人员综合统计分析-表格
 */
export const personStatisticsAction = (data) => {
  return commonGet(formatUrl(patrolUrls.personStatisticsUrl, data));
};

/**
 * 月度巡检情况-表格
 */
export const monthSituationAction = (body) => {
  return commonPost(patrolUrls.monthSituationUrl, body);
};

/**
 * 巡检首页-获取公司名、巡检点数、完成/计划、累计巡检次数、未完/已完任务数和巡检点数
 */
export const homeNumberAction = () => {
  return commonGet(patrolUrls.homeNumberUrl);
};

/**
 * 巡检首页-获取12日内 实际巡检、计划巡检和漏检次数每天的数值
 */
export const homeChartAction = () => {
  return commonGet(patrolUrls.homeChartUrl);
};
/**
 * 当前系统公司信息
 * (废弃)
 */
export const currentCompanyAction = () => {
  return commonGet(patrolUrls.currentCompanyUrl);
};
