import React from 'react';
import { render } from 'react-dom';

/**
 * 获取react组件渲染完后的html字符串
 * @param {*} Com  react组件
 */
export const getReactComponentHtml = async function(Com, callback) {
  let ele = document.getElementById('reactComponentHtml');
  if (!ele) {
    ele = document.createElement('div');
    ele.id = 'reactComponentHtml';
    ele.style.display = 'none';
    document.body.appendChild(ele);
  }
  render(Com, ele, () => {
    callback(ele.innerHTML);
  });
};

/**
 * 防止浏览器将登陆时记住的用户名和密码自动填充到系统中其他有密码框的输入框中
 * 一般放在有密码框对应form前面
 * @param {*} props
 */
export const NoUsernamePasswordFill = (props) => {
  const _style = { width: 0, height: 0, float: 'left', visibility: 'hidden' };
  return (
    <span>
      <input type="text" style={{ position: 'fixed',bottom: '-9999px' }} />
      <input type="password" style={{ position: 'fixed',bottom: '-9999px' }} />
    </span>
  );
};
