import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

export default function StdFormRow({ title, children, last, block, grid, ...rest }) {
  const cls = classNames('standard-form-row', {
    ['standard-form-rowblock']: block,
    ['standard-form-rowlast']: last,
    ['standard-form-rowgrid']: grid
  });

  return (
    <div className={cls} {...rest}>
      {
        title && (
          <div className="row-title">
            <span>{title}</span>
          </div>
        )
      }
      <div className="row-content">
        {children}
      </div>
    </div>
  );
}

StdFormRow.propTypes = {
  title: PropTypes.string,
  children: PropTypes.node,
  last: PropTypes.bool,
  block: PropTypes.bool,
  grid: PropTypes.bool
};


