import { Dropdown, Button, DropNav, Icon, Menu } from 'amos-framework';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import '../../../styles/view/component/toolbar.scss';
import { seachPermissionAction } from './../../../services/checkService';
/**
 * 工具栏
 *
 * @class ToolBar
 * @extends {Component}
 */
class ToolBar extends Component {
  constructor(props) {
    super(props);
    this.state = {
      navs: [],
      isWriteable: false,
      dropnavs: []
    };
  }

  componentWillReceiveProps(nextProps) {
    const { dropnavs } = nextProps;
    if (dropnavs && dropnavs.length > 0) {
      this.setState({ dropnavs: dropnavs });
      const permissionsMenus = window.localStorage.getItem('permissionsMenus');
      let data = [];
      if (permissionsMenus) {
        data = JSON.parse(permissionsMenus);
      }
      let children = [];
      if (data && dropnavs) {
        data.find(item => {
          if (item.permissionName === '巡检业务') {
            children = item.children;
            let menu = children.find(item => {
              if (dropnavs && dropnavs.length > 0) {
                if (void 0 === dropnavs[0].frontComponent) {
                  return true;
                }
                return dropnavs[0].frontComponent === item.permissionCode;
              }
            });
            if (!menu) {
              this.setState({ navs: [], isWriteable: false });
              return;
            }
            let navs = dropnavs.filter(item => {
              if (!item.isWriteable) {
                return true;
              }
              // return menu.isWriteable === item.isWriteable || item.isWriteable === false;
              return item.isWriteable;
            });
            // this.setState({ navs, isWriteable: menu.isWriteable });
            this.setState({ navs, isWriteable: true });
          }
        });
      }
    }
  }

  componentWillMount() {
    const { dropnavs } = this.state;
    const permissionsMenus = window.localStorage.getItem('permissionsMenus');
    let data = [];
    if (permissionsMenus) {
      data = JSON.parse(permissionsMenus);
    }
    let children = [];
    if (data && dropnavs) {
      data.find(item => {
        if (item.permissionName === '巡检业务') {
          children = item.children;
          let menu = children.find(item => {
            if (dropnavs && dropnavs.length > 0) {
              if (void 0 === dropnavs[0].frontComponent) {
                return true;
              }
              return dropnavs[0].frontComponent === item.permissionCode;
            }
          });
          if (!menu) {
            this.setState({ navs: [], isWriteable: false });
            return;
          }
          let navs = dropnavs.filter(item => {
            if (!item.isWriteable) {
              return true;
            }
            // return menu.isWriteable === item.isWriteable || item.isWriteable === false;
            return item.isWriteable;
          });
          // this.setState({ navs, isWriteable: menu.isWriteable });
          this.setState({ navs, isWriteable: true });
        }
      });
    }
  }

  getButton = (record) => {
    return (<Button onClick={(e) => this.handlerOnClick(record, e)} transparent value={record.key} icon={record.icon} >{record.text}</Button>);
  }

  getNavMenu = (record) => {
    if (record.subSys.length > 0 && record.subSys[0].href.startsWith('jacascript::void(0)')) {
      return (
        <Dropdown
          customContent={this.renderMenu(record.subSys)}
          onSelect={this.handlerOnClick}
          className='check-drop-down'
        >
          <div><Icon icon={record.icon} />{record.text}</div>
        </Dropdown>);
    } else {
      return (
        <Dropdown
          // menus={record.subSys}
          customContent={this.renderMenu(record.subSys)}
          onSelect={this.handlerOnClick}
          className='check-drop-down'
        >
          <Button onClick={(e) => this.handlerOnClick(record, e)} transparent value={record.key} icon={record.icon} >{record.text}</Button>
        </Dropdown>);
    }
  }

  getMenuItems = (subSys) => {
    let { callBack } = this.props;
    let items = new Array();
    for (let i = 0; i < subSys.length; i++) {
      let sub = subSys[i];
      items.push(<Menu.Item onClick={() => callBack(sub.key)}>{sub.text}</Menu.Item>);
    }
    return items;
  }

  getDropnav = (record) => {
    let arr = new Array();
    arr.push(record);
    return (<DropNav navs={arr} theme="light" />);
  }

  handlerOnClick = (navItem, e) => {
    let { callBack } = this.props;
    if (!navItem.href.startsWith('jacascript::void(0)')) {
      return true;
    }
    callBack(navItem.key, navItem.href);
    return false;
  }

  renderMenu = (subSys) => {
    return (
      <Menu>
        {this.getMenuItems(subSys)}
      </Menu>
    );
  }

  render() {
    const { navs } = this.state;
    let context = navs.map(item => {
      if (item.subSys) {
        return this.getNavMenu(item);
      } else if (!item.href.startsWith('jacascript::void(0)')) {
        return this.getDropnav(item);
      } else {
        return this.getButton(item);
      }
    });
    return (
      <div className='check-tool-root patrol-page-table-tool'>
        {context}
      </div>
    );
  }
}

ToolBar.propTypes = {
  callBack: PropTypes.func,
  dropnavs: PropTypes.array
};

export default ToolBar;
