import AmosGridTable from '../../component/table/table/AmosGridTable';
import React, { Component } from 'react';
import { AmosAlert } from 'amos-framework';
import dt2react from 'dt2react';
import { browserHistory } from 'amos-react-router';
import PropTypes from 'prop-types';
import { pathMapping } from './../../../routes/customRoutes';
import ToolBar from './../../component/toolbar';
import { batDelCatalogTreeAction, btnAuthAction } from '../../../services/checkService';

const inputUrl = () => pathMapping.catalogTreeInput;

const dropnavs1 = { key: '1', text: '添加', icon: 'add', href: 'jacascript::void(0)', permissionCode: 'catalogtree', isWriteable: true };
const dropnavs2 = { key: '2', text: '修改', icon: 'edit', href: 'jacascript::void(0)', permissionCode: 'catalogtree', isWriteable: true };
const dropnavs3 = { key: '3', text: '删除', icon: 'delete', href: 'jacascript::void(0)', permissionCode: 'catalogtree', isWriteable: true };

const getColumns = () => {
  return [
    {
      title: '编号',
      dataIndex: 'id',
      key: 'id',
      width: 100,
      className: 'uant-table-thead'
    },
    {
      title: '所属公司',
      dataIndex: 'orgName',
      key: 'orgName',
      width: 180,
      className: 'uant-table-thead'
    },
    {
      title: '分类名称',
      dataIndex: 'name',
      key: 'name',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '父类名称',
      dataIndex: 'parentName',
      key: 'parentName',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '创建者',
      dataIndex: 'createName',
      key: 'createName',
      width: 120,
      className: 'uant-table-thead'
    }
  ];
};

/**
 * 计划执行
 *
 * @class CheckTable
 * @extends {Component}
 */
class CheckTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      form: {
        planId: '',
        changeFlag: '0',
        beginDate: '',
        endDate: ''
      },
      modal: false,
      pagination: true,
      isChecked: true,
      selectedRows: [],
      selectedRowKeys: [],
      data: [],
      dropnavs: []
    };
  }

  /**
   * 组件初始化调用
   */
  componentWillMount = () => {
    this.reloadButtonAuth();
  };
  reloadButtonAuth = () => {
    // const _path = this.calcRoutes();
    btnAuthAction('/main/patrol/catalogtree').then(data => {
      let { dropnavs } = this.state;
      if (data) {
        if ('tj' in data && data.tj.hasPermission) {
          dropnavs.push(dropnavs1);
        }
        if ('xg' in data && data.xg.hasPermission) {
          dropnavs.push(dropnavs2);
        }
        if ('sc' in data && data.sc.hasPermission) {
          dropnavs.push(dropnavs3);
        }
      }

      this.setState({ dropnavs });
    });
  };
  /**
   * 分页设置参数
   */
  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  };

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  getRowClassName = (record, index) => {
    let highlight = this.highlight;
    if (highlight && record.id === highlight) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  clearSelectedRows = () => {
    this.setState({ selectedRows: [], selectedRowKeys: [] });
  };

  reloadPage = () => {
    this.clearSelectedRows();
    this.state.reload();
  };

  delCatalogTree = () => {
    let { selectedRowKeys } = this.state;
    if (selectedRowKeys === undefined || selectedRowKeys.length <= 0) {
      AmosAlert.warning('提示', '请先点击选择需要删除的行');
      return;
    }
    let ids = selectedRowKeys;
    AmosAlert.confirm('提示', '确定要删除指定的数据么?', {
      callback: flag => {
        if (flag) {
          // 确定删除
          batDelCatalogTreeAction(ids).then(
            data => {
              if (data === null) {
                AmosAlert.success('提示', '删除成功');
              } else {
                AmosAlert.error('提示', '删除分类失败：请先删除子节点');
              }
              this.reloadPage();
              this.props.catalogSearchCallback();
            },
            err => {
              AmosAlert.error('提示', err);
            }
          );
        }
      }
    });
  };

  editCatalogTree = () => {
    const { selectedRows } = this.state;
    if (selectedRows === undefined || selectedRows.length <= 0) {
      AmosAlert.warning('提示', '请选择要修改的分类');
      return;
    }
    if (selectedRows.length > 1) {
      AmosAlert.warning('提示', '至多选择一条要修改的分类');
      return;
    }
    let row = selectedRows[0];
    let path = {
      pathname: inputUrl(),
      state: { id: row.id }
    };
    browserHistory.push(path);
  };

  onClickBootBar = type => {
    if (type === '1') {
      browserHistory.push(inputUrl());
    } else if (type === '2') {
      this.editCatalogTree();
    } else if (type === '3') {
      this.delCatalogTree();
    }
  };

  onRowDoubleClick = (record, index, event) => {
    let row = record;
    let path = {
      pathname: inputUrl(),
      state: { id: row.id }
    };
    browserHistory.push(path);
  };

  render() {
    let { pagination, isChecked, modal, selectedRowKeys, dropnavs } = this.state;
    let { dataList, fetchData, count } = this.props;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="patrol-page-table">
        <ToolBar dropnavs={dropnavs} callBack={this.onClickBootBar} />
        <AmosGridTable
          rowKey="id"
          columns={getColumns()}
          callBack={this.reload}
          isPageable={pagination}
          dataList={dataList}
          totals={count}
          selectedRowKeys={selectedRowKeys}
          getTableDataAction={fetchData}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          onRowDoubleClick={this.onRowDoubleClick}
          isChecked={isChecked}
        />
      </div>
    );
  }
}

CheckTable.propTypes = {
  changeType: PropTypes.string,
  queryParam: PropTypes.object,
  catalogSearchCallback: PropTypes.func
};

export default CheckTable;
