import React, { Component } from 'react';
import PropTypes from 'prop-types';
import CatalogTreeTable from './CatalogTreeTable';
import CatalogTreeSearch from './CatalogTreeSearch';
import { queryCatalogTreePageAction, queryCatalogTreeAction } from '../../../services/checkService';
import { pathMapping } from './../../../routes/customRoutes';
import { browserHistory } from 'amos-react-router';
import SplitterLayout from '../../component/SplitLayout';

/**
 * 分类树
 *
 * @class CatalogTree
 * @extends {Component}
 */
class CatalogTree extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      statisticsData: [],
      totalCount: 0,
      treeData: []
    };
  }
  componentWillMount = () => {
    this.queryCatalogTree();
  };

  onSearchDataSyn = (queryParam, param) => {
    let quest = [];
    if (queryParam) {
      for (let key in queryParam) {
        let obj = queryParam[key];
        quest.push(obj);
      }
    }
    this.setState({ searchParam: quest }, () => {
      this.questStatistiscData(param);
    });
  };

  questStatistiscData = param => {
    let { searchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    this.queryCatalogTreeInfo(searchParam, pageNumber, pageSize);
  };

  queryCatalogTreeInfo(searchParam, pageNumber, pageSize) {
    queryCatalogTreePageAction(searchParam, pageNumber, pageSize).then(data => {
      let statisticsData = data.content;
      let totalCount = data.totalElements;
      this.setState({
        statisticsData,
        totalCount
      });
    });
  }

  queryCatalogTree = () => {
    queryCatalogTreeAction().then(data => {
      let treeData = data;
      this.setState({ treeData });
    });
  };

  render() {
    let { statisticsData, totalCount, treeData } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <CatalogTreeSearch treeData={treeData} search={this.onSearchDataSyn} />
        </SplitterLayout>
        <CatalogTreeTable count={totalCount} fetchData={this.questStatistiscData} dataList={statisticsData} catalogSearchCallback={this.queryCatalogTree} />
      </div>
    );
  }
}

CatalogTree.propTypes = {};

export default CatalogTree;
