import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
// import { Col } from 'amos-framework/lib/grid';
 import './../../../../styles/view/biz/checkDetail/checkDetail.scss';
 import './../../../../styles/view/biz/checkDetail/checkDetailTable.scss';
/**
 * 巡检记录详情
 */
class CheckDetailTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      checkDetail: props.checkDetail
    };
  }

  showLivePic = (record, e) => {
    this.props.showPic(record, e);
  }

  render() {
    let { checkDetail = {} } = this.props;
    let checkUserName;
    let group;
    let routeName;
    let planName;
    let planRemark;
    let remark;
    let isOK;
    let contact;
    let checkScore;
    let photosUrlCount = 0;
    if (checkDetail) {
      checkUserName = checkDetail.checkUserName;
      group = checkDetail.group;
      routeName = checkDetail.routeName;
      planName = checkDetail.planName;
      planRemark = checkDetail.planRemark;
     

      if(checkDetail.isOK==='不合格'){
        isOK = '异常';
      }else if(checkDetail.isOK==='合格'){
        isOK = '正常';
      }else{
        isOK = checkDetail.isOK;
      }



      contact = checkDetail.contact === '' ? '无' : checkDetail.contact;
      checkScore = checkDetail.checkScore;
      remark = checkDetail.checkRemark;
      photosUrlCount = checkDetail.photosUrl ? checkDetail.photosUrl.length : 0;
    }

    return (
      <Row className='check-detail-table'>
        <Row className='check-detail-table-row1'>
          <Col className='colTitle'>巡检人员</Col>
          <Col className='colValue'>{checkUserName}</Col>
          <Col className='colTitle'>部门</Col>
          <Col className='colValue'>{group}</Col>
          <Col className='colTitle'>联系方式</Col>
          <Col className='colValue'>{contact}</Col>
          <Col className='colTitle'>巡检状态</Col>
          <Col className='colValue'>{isOK}</Col>
        </Row>
        <Row className='check-detail-table-row2'>
          <Col className='colTitle'>巡检路线</Col>
          <Col className='colValue3'>{routeName}</Col>
          <Col className='colTitle'>计划名称</Col>
          <Col className='colValue'>{planName}</Col>
        </Row>
        <Row className='check-detail-table-row2'>
          <Col className='colTitle'>巡检计划</Col>
          <Col className='colValue3'>{planRemark}</Col>
          <Col className='colTitle'>检查评分</Col>
          <Col className='colValue'>{checkScore}</Col>
        </Row>
        <Row className='check-detail-table-row2'>
          <Col className='colTitle'>检查备注说明</Col>
          <Col className='colValue3'>{remark}</Col>
          <Col className='colTitle'>现场照片</Col>
          <Col className='colValue'>
            <span>
              {photosUrlCount === 0 ? '无图片上传' : (<a href="javascript:;" onClick={this.showLivePic.bind(this, {checkDetailPhotosUrl:checkDetail.photosUrl})}>查看</a>)}
            </span>
          </Col>
        </Row>
      </Row>
    );
  }
}

CheckDetailTable.propTypes = {
  checkDetail: PropTypes.object,
  showPic: PropTypes.func
};

export default CheckDetailTable;
