import React, { Component } from 'react';
import moment from 'moment';
import CheckTable from './CheckTable';
import CheckSearch from './CheckSearch';
import ExportSearch from './ExportSearch';
import ExportCheckSearch from './ExportCheckSearch';

import { queryCheckInfoAction } from '../../../services/checkService';
import SplitterLayout from './SplitLayout';

/**
 * 巡检记录
 *
 * @class Check
 * @extends {Component}
 */
class Check extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      statisticsData: [],
      totalCount: 0,
      planId: '',
      pointNo: '',
      showType: ''
    };
  }
  componentWillMount = () => {
    const { planId, pointNo } = (this.props.location || {}).state || {};
    let { searchParam } = this.state;
    let beginToday = moment(new Date()).format('YYYY-MM-DD') + ' 00:00:00';
    let endToday = moment(new Date()).format('YYYY-MM-DD') + ' 23:59:59';
    searchParam.push({ name: 'beginDate', value: beginToday });
    searchParam.push({ name: 'endDate', value: endToday });
    if (planId) {
      searchParam.push({ name: 'planId', value: planId });
      this.setState({ searchParam, planId });
    }
    if (pointNo) {
      searchParam.push({ name: 'pointNo', value: pointNo });
      this.setState({ searchParam, pointNo });
    }
  };

  onSearchDataSyn = (queryParam, param) => {
    let quest = [];
    if (queryParam) {
      for (let key in queryParam) {
        let obj = queryParam[key];
        quest.push(obj);
      }
    }
    this.setState({ searchParam: quest }, () => {
      this.questStatistiscData(param);
    });
  };

  questStatistiscData = param => {
    let { searchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    this.queryCheckInfo(searchParam, pageNumber, pageSize);
  };

  queryCheckInfo(searchParam, pageNumber, pageSize) {
    queryCheckInfoAction(searchParam, pageNumber, pageSize).then(data => {
      let statisticsData = data.content;
      let totalCount = data.totalElements;
      this.setState({
        statisticsData,
        totalCount
      });
    });
  }

  setShowType = value => {
    this.setState({ showType: value });
  };

  render() {
    let { statisticsData, totalCount, planId, pointNo, searchParam, showType } = this.state;
    console.log(showType);
    return (
      <div className="patrol-page-content">
        {showType === 'search' && (
          <SplitterLayout title="查询条件">
            <CheckSearch search={this.onSearchDataSyn} planId={planId} pointNo={pointNo} />
          </SplitterLayout>
        )}
        {showType === 'export' && (
          <SplitterLayout title="报表生成">
            <ExportSearch search={this.onSearchDataSyn} planId={planId} pointNo={pointNo} />
          </SplitterLayout>
        )}
        {showType === 'check' && (
          <SplitterLayout title="业务报表">
            <ExportCheckSearch />
          </SplitterLayout>
        )}
        <CheckTable
          count={totalCount}
          fetchData={this.questStatistiscData}
          searchParam={searchParam}
          dataList={statisticsData}
          planId={planId}
          setShowType={this.setShowType}
        />
      </div>
    );
  }
}

Check.propTypes = {};

export default Check;
