import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'amos-react-router';
import Icon from 'amos-icon';
import PatrolChart from './PatrolChart';
import { pathMapping } from './../../../routes/customRoutes';
import {
  homeNumberAction,
  homeChartAction
} from './../../../services/statisticsService';

const dataList = [
  { key: '1', img: '/src/assets/fsc/img/task.png', color: '#5cb85c', href: pathMapping.plan, varName: 'plan', title: '完成/计划(日检)' },
  { key: '2', img: '/src/assets/fsc/img/total.png', color: '#337ab7', href: pathMapping.check, varName: 'check', title: '累计巡检次数' },
  { key: '3', img: '/src/assets/fsc/img/xl.png', color: '#f0ad4e', href: pathMapping.tasktask, varName: 'task', title: '未完/已完(任务)' },
  { key: '4', img: '/src/assets/fsc/img/point.png', color: '#d9534f', href: pathMapping.point, varName: 'point', title: '巡检点数' }
];

/**
 * 巡检业务首页
 *
 * @class PatrolHome
 * @extends {Component}
 */
class PatrolHome extends Component {
  constructor(props) {
    super(props);
    this.state = {
      company: '0',
      statusList: {
        plan: '0/0',
        check: '0',
        task: '0/0',
        point: '0'
      },
      data: {
        xAxis: [],
        check: [],
        plan: [],
        missed: []
      }
    };
  }

  componentDidMount() {
    homeNumberAction().then(d => {
      this.setState({
        company: d.company,
        statusList: d.statusList
      });
    });
    homeChartAction().then(d => {
      this.setState({ data: d });
    });
  }

  render() {
    if (this.props.children) {
      return (<div className="wh-r">{this.props.children}</div>);
    }
    const { company, statusList, data } = this.state;
    return (
      <div className="patrol-home">
        {/**<div className="patrol-home-top">
          <span>应用名称：{company}</span>
            </div>**/}
        <ul className="patrol-home-kb">
          {
            dataList.map(e => (
              <li key={e.key} className="patrol-home-kb-item" style={{ borderColor: e.color }}>
                <div className="patrol-home-kb-info" style={{ backgroundColor: e.color }}>
                  <img src={e.img} alt="" />
                  <div className="patrol-home-kb-details">
                    <div className="patrol-home-kb-value">{statusList[e.varName]}</div>
                    <div>{e.title}</div>
                  </div>
                </div>
                <div className="patrol-home-kb-link" style={{ color: e.color }}>
                  <Link to={e.href}>
                    <span>更多...</span>
                    <span className="patrol-home-kb-link-arrow"><Icon icon="leftArrow" /></span>
                  </Link>
                </div>
              </li>
            ))
          }
        </ul>
        <PatrolChart data={data} />
      </div>
    );
  }
}

PatrolHome.propTypes = {
  children: PropTypes.node
};

export default PatrolHome;
