import React, { Component } from 'react';
import InputItemSearch from './inputItemSearch';
import InputItemTable from './inputItemTable';
import SplitterLayout from '../../component/SplitLayout';

/**
 * 巡检项
 *
 * @class InputItem
 * @extends {Component}
 */
class InputItem extends Component{
  state = {
    changeType: '',
    queryParam: {}
  }

  queryTableData = (requestParam) =>{
    this.setState({ changeType: 'query', queryParam: requestParam });
  }

  render() {
    const { changeType, queryParam } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <InputItemSearch search={this.queryTableData} />
        </SplitterLayout>
        <InputItemTable  changeType={changeType} queryParam={queryParam}  />
      </div>
    );
  }
}

InputItem.propTypes = {};

export default InputItem;
