import React, { Component } from 'react';
import { Form, Input, Button, Select } from 'amos-framework';

import PropTypes from 'prop-types';
import  './../../../styles/view/patrol/inputItem.scss';

const FormItem = Form.Item;
const Option = Select.Option;

/**
 * 巡检项
 *
 * @class InputItemSearch
 * @extends {Component}
 */
class InputItemSearch extends Component{
  constructor(props) {
    super(props);
    this.state = {
      form: {

        isScore: {
          name: 'isScore',
          value: ''
        },
        name: { name: 'name', value: '', type: 'LIKE' },
        itemType: {
          name: 'itemType',
          value: ''
        },
        level: {
          name: 'level',
          value: ''
        },
        itemNo: { name: 'itemNo', value: '', type: 'LIKE' },
      }
    };
  }
  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  }
  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  }

  // handleSubmit = () => {
  //   let { form } = this.state;
  //   const param = { pageNumber: 0, pageSize: 10 };
  //   this.props.search(form, param);
  // };

  handleSubmit = () => {
    const { form } = this.state;
    const pageParam = { pageNumber: 0, pageSize: 10 };
    this.props.search(form,pageParam);
  }
  render() {
    const { form } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo"  model={form} >

        <FormItem label={<span>名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} prefixCls="" className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label={<span>编号</span>} field="itemNo" {...formItemLayout}>
          <Input value={form.itemNo.value} prefixCls="" className="search_Input" onChange={e => this.onChange('itemNo', e)} />
        </FormItem>
        <Input className="input_hide"/>
        <FormItem label="类型" field="itemType" {...formItemLayout} >
          <Select defaultOption={<Option value="">全部</Option>} className="search_Input" value={form.itemType.value} onChange={(e) => this.onSelectChange('itemType', e)}>
            <Option value="文本">文本检查项</Option>
            <Option value="数字">数字检查项</Option>
            <Option value="选择">选择检查项</Option>
          </Select>
        </FormItem>
        <FormItem label="等级" field="level" {...formItemLayout} >
          <Select value={form.level.value}
            defaultOption={<Option value="">全部</Option>}
            className="search_Input"
            onChange={(e) => this.onSelectChange('level', e)}
          >
            <Option value="-0">无等级</Option>
            <Option value="1">1级</Option>
            <Option value="2">2级</Option>
            <Option value="3">3级</Option>
            <Option value="4">4级</Option>
            <Option value="5">5级</Option>
          </Select>
        </FormItem>

        <FormItem label="是否评分" field="isScore" {...formItemLayout} >
          <Select value={form.isScore.value}
            defaultOption={<Option value="">全部</Option>}
            prefixCls=""
            className="search_Input"
            onChange={(e) => this.onSelectChange('isScore', e)}
          >
            <Option value="是">评分</Option>
            <Option value="否">不评分</Option>
          </Select>
        </FormItem>

        <FormItem  className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>查询</Button>
        </FormItem>
      </Form>
    );
  }
}

InputItemSearch.propTypes = {};

export default InputItemSearch;
