import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosAlert, message } from 'amos-framework';
import { browserHistory } from 'amos-react-router';
import moment from 'moment';
import AmosGridTable from '../../component/table/table/AmosGridTable';
import { pathMapping } from './../../../routes/customRoutes';
import ToolBar from './../../component/toolbar';
import { deleteNewsAction, repeatNewsAction } from './../../../services/newsService';
import { btnAuthAction } from '../../../services/checkService';
const newsAdd = pathMapping.newsAdd;

  const dropnavs1 ={ key: '1', text: '通知', icon: 'add', href: 'jacascript::void(0)', permissionCode: 'news', isWriteable: true };
  // { key: '2', text: '重发', icon: 'edit', href: 'jacascript::void(0)', permissionCode: 'news', isWriteable: true },
  // { key: '3', text: '删除', icon: 'save', href: 'jacascript::void(0)', permissionCode: 'news', isWriteable: true }

const getColumns = () => {
  return [
    {
      title: '用户名',
      dataIndex: 'userName',
      key: 'userName',
      width: 120,
      className: 'uant-table-thead'
    },
    {
      title: '消息类型',
      dataIndex: 'msgType',
      key: 'msgType',
      width: 100,
      className: 'uant-table-thead'
    },
    {
      title: '消息内容',
      dataIndex: 'msgBody',
      key: 'msgBody',
      className: 'uant-table-thead',
      width: 480,
      render: text => {
        return <div style={{ textAlign: 'left' }} dangerouslySetInnerHTML={{ __html: text }} />;
      }
    },
    {
      title: '发送时间',
      dataIndex: 'sendTime',
      key: 'sendTime',
      width: 140,
      className: 'uant-table-thead',
      render: text => text ? moment(text).format('YYYY-MM-DD HH:mm:ss') : ''
    },
    {
      title: '是否定时发送',
      dataIndex: 'isImmediately',
      key: 'isImmediately',
      width: 120,
      className: 'uant-table-thead',
      render: text => text === '是' ? '否' : '是'
    },
    {
      title: '定时发送时间',
      dataIndex: 'fixedTime',
      key: 'fixedTime',
      width: 150,
      className: 'uant-table-thead',
      render: text => text ? moment(text).format('YYYY-MM-DD HH:mm:ss') : ''
    }
  ];
};

/**
 * 消息提醒表格
 *
 * @class NewsTable
 * @extends {Component}
 */
class NewsTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: true,
      selectedRows: [],
      selectedRowKeys: [],
      data: [],
      dropnavs:[]
    };
  }


  onRemove = () => {
    let { selectedRowKeys } = this.state;
    if (selectedRowKeys === undefined || selectedRowKeys.length <= 0) {
      AmosAlert.warning('提示', '请先点击选择需要删除的行');
      return;
    }
    let ids = selectedRowKeys;
    AmosAlert.confirm('提示', '确定要删除指定的数据么?', {
      callback: flag => {
        if (flag) {
          deleteNewsAction(ids).then(
            data => {
              message.success('提示', '删除成功');
              this.reloadPage();
            },
            err => {
              message.danger('错误', err);
            }
          );
        }
      }
    });
  };

  onRepeat = () => {
    AmosAlert.confirm('提示', '确定重新发送这些消息么?', {
      callback: flag => {
        if (flag) {
          repeatNewsAction().then(
            data => {
              message.success('提示', '重新发送成功');
              this.reloadPage();
            },
            err => {
              message.danger('错误', err);
            }
          );
        }
      }
    });
  };

  onClickBootBar = type => {
    if (type === '1') {
      browserHistory.push(newsAdd);
    } else if (type === '2') {
      this.onRepeat();
    } else if (type === '3') {
      this.onRemove();
    }
  };

  /**
   * 分页设置参数
   */
  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  };

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  getRowClassName = (record, index) => {
    let highlight = this.highlight;
    if (highlight && record.id === highlight) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  };


  componentWillMount = () => {
    this.reloadButtonAuth();

  };

  reloadButtonAuth = () => {
    // const _path = this.calcRoutes();
    btnAuthAction('/main/patrol/news').then(data => {
      
      let { dropnavs } = this.state;
     if(data){
  
       if("xxtx" in data&&data.xxtx.hasPermission){
        dropnavs.push( dropnavs1);
       }
  
     }
  
      this.setState({ dropnavs});
    });
  }

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  clearSelectedRows = () => {
    this.setState({ selectedRows: [], selectedRowKeys: [] });
  };

  reloadPage = () => {
    this.clearSelectedRows();
    this.state.reload();
  };

  render() {
    let { dataList, fetchData, count } = this.props;
    let { pagination, isChecked, selectedRowKeys,dropnavs } = this.state;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="patrol-page-table">
        <ToolBar dropnavs={dropnavs} callBack={this.onClickBootBar} />
        <AmosGridTable
          rowKey="id"
          columns={getColumns()}
          callBack={this.reload}
          isPageable={pagination}
          dataList={dataList}
          totals={count}
          selectedRowKeys={selectedRowKeys}
          getTableDataAction={fetchData}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          isChecked={isChecked}
        />
      </div>
    );
  }
}

NewsTable.propTypes = {
  queryParam: PropTypes.object,
  dataList: PropTypes.array,
  fetchData: PropTypes.func,
  count: PropTypes.number
};

export default NewsTable;
