import React, { Component } from 'react';
import { DatePicker,TimePicker } from 'amos-antd';
import moment from 'moment';
import { browserHistory } from 'amos-react-router';
import { Form, AmosAlert, MultiSelect, Input, Radio, Button, Select, Checkbox, InputNumber } from 'amos-framework';
import {
  createPlanAction,
  queryDeptByOrgCodeAction1,
  queryUserByDeptIdAction,
  queryPlanDetByIdAction,
  queryAllRouteAction
} from '../../../services/checkService';
import HasPermission from './../../component/toolbar/hasPermission';
import '../../../styles/view/patrol/PlanInput.scss';
import YearPicker from '../../common/YearPicker';

import {  Store } from 'amos-tool';
const lsTool = Store.lsTool;
const format = 'HH:mm';
const formatValue = 'HH:mm:ss';


const { WeekPicker, MonthPicker } = DatePicker;
const TextArea = Input.TextArea;
const FormItem = Form.Item;
const RadioGroup = Radio.Group;
const Option = Select.Option;
const CheckboxGroup = Checkbox.Group;
const exeIntData = [{ id: '1', name: '小时' }, { id: '2', name: '分钟' }, { id: '3', name: '秒' }];
const dayInterUnitEum = { 1: '小时', 2: '分钟', 3: '秒' };
const rateData = [1, 2, 3, 4, 6, 12];
const weeKData = [
  { id: 1, name: '星期一' },
  { id: 2, name: '星期二' },
  { id: 3, name: '星期三' },
  { id: 4, name: '星期四' },
  { id: 5, name: '星期五' },
  { id: 6, name: '星期六' },
  { id: 7, name: '星期日' }
];
const weeKDataEum = { 1: '星期一' , 2: '星期二' , 3: '星期三' ,4: '星期四',5: '星期五' ,6: '星期六' ,7: '星期日' };
const whatWeekEum = { 1: '第一周' , 2: '第二周' , 3: '第三周' , 4: '第四周' , 5: '最后一周' };
const whatWeekKData = [{ id: 1, name: '第一周' }, { id: 2, name: '第二周' }, { id: 3, name: '第三周' }, { id: 4, name: '第四周' }, { id: 5, name: '最后一周' }];
const unitData = { 1: '天', 2: '周', 3: '月', 4: '年' };
const radioStyle = {
  display: 'block',
  height: '30px',
  lineHeight: '30px',
  left: '175px'
};

class PlanInput extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: '',
        inOrder: '0',
        isScore: '1',
        isFixedDate: '1',
        dayRate: 0,
        planType: '1',
        whatDay: 1,
        whatDayArr: [],
        whatWeek: 1,
        dayInterval: '1',
        dayIntervalUnit: '1',
        executeRate: 1,
        routeId: null,
        weekBeginNum: 1,
        weekEndNum: 7,
        weekDay: 1,
        monthType: '1',
        planBegin: moment().format('YYYY-MM-DD'),
        planEnd: null,
        executeInterval: '1',
        dayBegin: '08:00:00',
        dayTime: '08:00:00',
        dayEnd: '18:00:00',
        duration: '60',
        error: '0',
        remark: '',
        remark1: '',
        tepmUnit: '天',
        isSingleExecution:true
      },
      userData: [],
      routeData: [],
      deptData: [],
      dayData: [{ id: 1 }, { id: 2 }, { id: 3 }, { id: 4 }, { id: 5 }, { id: 6 }, { id: 7 }],
      rules: {
        name: [{ required: true, message: '请输入计划名称' }],
        routeId: [{ required: true, message: '请选择巡检路线' }],
        planBegin: [{ required: true, message: '请选择开始日期' },{ validator: this.validPlanBegin }],
        planEnd: [{ validator: this.validPlanEnd }]
      }
    };
  }

  componentWillMount = () => {
    this.queryRouteByOrgCode();
    this.queryDeptByOrgCode();
    const { planId } = (this.props.location || {}).state || {};
    planId ? this.onInit(planId) : this.initRemark();
  };

  onInit = planId => {
    queryPlanDetByIdAction(planId).then(data => {
      let whatDayArr = data.whatDay ? data.whatDay.split(',') : [];
      let userIdArr = data.userId ? data.userId.split(',') : [];
      Object.assign(data, { whatDayArr });
      Object.assign(data, { userId: userIdArr });
      let deptId = data.deptId;
      let inter = data.executeInterval;
      data.tepmUnit = unitData[data.planType];
      let dayData = [];
      for (let i = 1; i <= inter * 7; i++) {
        dayData.push({ id: i });
      }
      deptId > 0 && this.queryUserByDept(deptId);
      this.setState({ form: data, dayData });
    });
  };

  onChange = (key, e) => {
    const { form } = this.state;
    const value = e.target.value;
    form[key] = value;
    this.setState({ form });
  };

  onTimeChange = (key, date) => {
    const { form } = this.state;
    form[key] = date ? moment(date).format(formatValue) : null;
    this.dynamicCreatRemark(form);
  };

  onDateChange = (key, date) => {
    const { form } = this.state;
    form[key] = date ? moment(date).format('YYYY-MM-DD') : null;
    this.dynamicCreatRemark(form);
  };

  onSelectChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.dynamicCreatRemark(form);
  };

  onDeptChange = (key, value) => {

    let keyd= lsTool.read('departmentdate');

    const { form } = this.state;
    form[key] = value;
    this.queryUserByDept(value);
    this.setState({ form });
  //  if(keyd!='null'){
  //      if(value!=keyd){

  //        AmosAlert.error('提示', '只能选择本部门');
  //        form[key] = '';
  //        this.setState({ userData: [] });
  //       this.setState({ form });

  //      }else{
  //        form[key] = value;
  //        this.queryUserByDept(value);
  //        this.setState({ form });
  //      }

  //  }else{
  //   form[key] = value;
  //   this.queryUserByDept(value);
  //   this.setState({ form });

  //  }




  };

  onPlanTypeChange = (key, value) => {
    let { form } = this.state;
    form[key] = value;
    form.tepmUnit = unitData[value];
    if (parseInt(value) === 4 ){
      form.planBegin = moment().startOf('year').format('YYYY-MM-DD');
    } else {
      form.planBegin = moment().format('YYYY-MM-DD');
    }
    this.dynamicCreatRemark(form);
  };

  onCheckboxChange = selects => {
    const { form } = this.state;
    form.whatDayArr = selects;
    this.dynamicCreatRemark(form);
  }

  getRemarkByPlanTypeForFix = (form) => {
    if (form.dayRate === 0 ){
      form.remark = '每' + form.executeInterval + this.getThreeChar(form.planType) + this.getDetInfoByPlanType(form) + '的' + form.dayTime.substring(0,5) + '执行。' + '将从' + form.planBegin + (form.planEnd ? '到' + form.planEnd + '之间' : '开始' ) + '使用计划。';
    } else if ( form.dayRate === 1 ){
      form.remark = '每' + form.executeInterval + this.getThreeChar(form.planType) + this.getDetInfoByPlanType(form) + '在' + form.dayBegin.substring(0,5) +
      '和 ' + form.dayEnd.substring(0,5) + '之间、' + '每' + form.dayInterval + dayInterUnitEum[form.dayIntervalUnit] + '执行。' + '将从' + form.planBegin + (form.planEnd ? '到' + form.planEnd + '之间' : '开始') + '使用计划。';
    }
    return form.remark;
  }

  dynamicCreatRemark = (form) =>{
    const { planType, isFixedDate } = form;
    let temp = {};
    Object.assign(temp, form);
    if (isFixedDate === '1'){
      form.remark = this.getRemarkByPlanTypeForFix(temp);
    } else {
      if (planType === '1'){
        form.remark = this.getRemarkByPlanTypeForFix(temp);
      } else if (planType === '2'){
        form.remark = '执行区间:' + '第' + form.weekBeginNum  + '天' +  form.dayBegin.substring(0,5) + '至' + '第' + form.weekEndNum + '天' +  form.dayEnd.substring(0,5) + '结束';
      } else if (planType === '3'){
        form.remark = '执行区间:开始日期所在月1号00:00至下月1号00:00';
      } else if (planType === '4'){
        form.remark = '每' + form.executeInterval + '年执行,' + '执行频率：1年' + form.executeRate + '次';
      }
    }
    this.setState({ form });
  }

  getRateMenu = (htmlArray, formItemLayout) => {
    let tempArry = htmlArray;
    let { dayRate } = this.state.form;
    let { form } = this.state;
    console.log(moment(form.dayTime, 'HH:mm'));
    //value={moment(form.dayTime).format('HH:mm')}

    if (dayRate === 0) {
      tempArry.push(
        <FormItem label={<span>时间为</span>} field="dayTime" {...formItemLayout}>
          <TimePicker value={moment(form.dayTime, 'HH:mm')} format={format} className="plan_info_input"  required  onChange={e => this.onTimeChange('dayTime', e)} />
        </FormItem>
      );
    } else if (dayRate === 1) {
      tempArry.push(
        <div>
          <FormItem label={<span>执行间隔</span>} field="dayInterval" {...formItemLayout}>
            <InputNumber
              className="plan_info_input"
              value={form.dayInterval}
              min={1}
              placeholder="执行间隔"
              onChange={e => this.onSelectChange('dayInterval', e)}
            />
            <Select
              data={exeIntData}
              renderOption={item => <Option value={item.id}>{item.name}</Option>}
              defaultValue={form.dayIntervalUnit}
              onChange={e => this.onSelectChange('dayIntervalUnit', e)}
            />
          </FormItem>
          <FormItem label={<span>开始时间</span>} field="dayBegin" {...formItemLayout}>
            <TimePicker value={moment(form.dayBegin, 'HH:mm')} format={format} className="plan_info_input"  required  onChange={e => this.onTimeChange('dayBegin', e)} />
          </FormItem>
          <FormItem label={<span>结束时间</span>} field="dayEnd" {...formItemLayout}>
            <TimePicker value={moment(form.dayEnd, 'HH:mm')} format={format} className="plan_info_input"  required  onChange={e => this.onTimeChange('dayEnd', e)} />
          </FormItem>
        </div>
      );
    }
    return tempArry;
  };

  onMonthDateChange = (key, date) => {
    const { form } = this.state;
    if (key === 'planBegin') {
      form[key] = moment(date).startOf('month').format('YYYY-MM-DD');
    } else {
      form[key] = date ? moment(date).endOf('month').format('YYYY-MM-DD') : null;
    }
    this.setState({ form });
  }

  onYearDateChange =(key,date) =>{
    const { form } = this.state;
    if (key === 'planBegin') {
      form[key] = moment(date + '').startOf('year').format('YYYY-MM-DD');
    } else {
      form[key] = date ? moment(date + '').endOf('year').format('YYYY-MM-DD') : null;
    }
    this.setState({ form });
  }

  onWeekDateChange = (key, date) => {
    const { form } = this.state;
    if (key === 'planBegin') {
      form[key] = moment(date).startOf('week').format('YYYY-MM-DD');
    } else {
      form[key] = date ? moment(date).endOf('week').format('YYYY-MM-DD') : null;
    }
    this.setState({ form });
  }

  getThreeChar =(planType) =>{
    let temp = unitData[planType];
    if (planType === '3'){
      temp = '个' + temp;
    }
    return temp;
  }

  getDetInfoByPlanType =(form)=>{
    let remark = '';
    let arry = [];
    if (form.planType === '1'){
      remark = '';
    } else if (form.planType === '2'){
      let { whatDayArr } = form;
      arry = whatDayArr.map(item =>{
        return weeKDataEum[item];
      });
      remark = arry.join(',');
    } else if (form.planType === '3'){
      if (form.monthType === '1'){
        remark = ',于当月第' + form.whatDay + '天';
      } else if (form.monthType === '2'){
        remark = ',于' + whatWeekEum[form.whatWeek] + weeKDataEum[form.weekDay];
      }
    }
    return remark;
  }

  getMenuByisFixedDate = formItemLayout => {
    let { planType, isFixedDate } = this.state.form;
    let { form, dayData } = this.state;
    let htmlArray = [];
    if (isFixedDate === '1') {
      htmlArray.push(
        <FormItem label={<span>计划类型</span>} field="planType" {...formItemLayout}>
          <RadioGroup defaultValue={form.planType} value={form.planType} onChange={e => this.onPlanTypeChange('planType', e)}>
            <Radio value="1">天</Radio>
            <Radio value="2">周</Radio>
            <Radio value="3">月</Radio>
          </RadioGroup>
        </FormItem>
      );
      htmlArray.push(
        <FormItem label={<span>执行间隔</span>} field="executeInterval" {...formItemLayout}>
          <InputNumber
            className="plan_info_input"
            value={form.executeInterval}
            min={1}
            placeholder="执行间隔"
            onChange={e => this.onSelectChange('executeInterval', e)}
          />
          <span className="ant-form-text">{form.tepmUnit}</span>
        </FormItem>
      );
      if (planType === '2') {
        htmlArray.push(
          <FormItem label={<span>在</span>} field="whatDayArr" {...formItemLayout}>
            <CheckboxGroup defaultSelects={form.whatDayArr} onChange={selects => this.onCheckboxChange(selects)}>
              <Checkbox value="1">星期一</Checkbox>
              <Checkbox value="2">星期二</Checkbox>
              <Checkbox value="3">星期三</Checkbox>
              <Checkbox value="4">星期四</Checkbox>
              <Checkbox value="5">星期五</Checkbox>
              <Checkbox value="6">星期六</Checkbox>
              <Checkbox value="7">星期日</Checkbox>
            </CheckboxGroup>
          </FormItem>
        );
      } else if (planType === '3') {
        htmlArray.push(
          <div className="month-setting">
            <FormItem field="monthType" className="month-setting-type" {...formItemLayout}>
              <RadioGroup
                className="month-settting-way"
                defaultValue={form.monthType}
                value={form.monthType}
                onChange={e => this.onSelectChange('monthType', e)}
              >
                <Radio value="1" style={radioStyle}>
                  第：
                </Radio>
                <Radio value="2" style={radioStyle}>
                  在：
                </Radio>
              </RadioGroup>
            </FormItem>
            <FormItem field="whatDay" className="month-setting-form" {...formItemLayout}>
              <InputNumber className="plan_info_input" value={form.whatDay} min={1} onChange={e => this.onSelectChange('whatDay', e)} />&nbsp;天
            </FormItem>
            <FormItem field="whatWeek" className="month-setting-form" {...formItemLayout}>
              第几周：&nbsp;
              <Select
                searchable
                data={whatWeekKData}
                renderOption={item => <Option value={item.id}>{item.name}</Option>}
                defaultValue={form.whatWeek}
                onChange={e => this.onSelectChange('whatWeek', e)}
              />
              &nbsp;周几：&nbsp;
              <FormItem field="weekDay" className="month-setting-weekday">
                <Select
                  searchable
                  data={weeKData}
                  renderOption={item => <Option value={item.id}>{item.name}</Option>}
                  defaultValue={form.weekDay}
                  onChange={e => this.onSelectChange('weekDay', e)}
                />
              </FormItem>
            </FormItem>
          </div>
        );
      }
      htmlArray.push(
        <FormItem label={<span>每天频率</span>} field="dayRate" {...formItemLayout}>
          <RadioGroup defaultValue={form.dayRate} value={form.dayRate} onChange={e => this.onSelectChange('dayRate', e)}>
            <Radio value={0}>一次</Radio>
            <Radio value={1}>多次</Radio>
          </RadioGroup>
        </FormItem>
      );
      htmlArray = this.getRateMenu(htmlArray, formItemLayout);
      htmlArray.push(
        <div>
          <FormItem label={<span>工作时长(分钟)</span>} field="duration" {...formItemLayout}>
            <InputNumber className="plan_info_input" value={form.duration} min={1} onChange={e => this.onSelectChange('duration', e)} />
          </FormItem>
          <FormItem label={<span>允许误差(分钟)</span>} field="error" {...formItemLayout}>
            <InputNumber className="plan_info_input" value={form.error} min={0} onChange={e => this.onSelectChange('error', e)} />
          </FormItem>
        </div>
      );
    } else if (isFixedDate === '0') {
      htmlArray.push(
        <FormItem label={<span>计划类型</span>} field="planType" {...formItemLayout}>
          <RadioGroup defaultValue={form.planType} value={form.planType} onChange={e => this.onPlanTypeChange('planType', e)}>
            <Radio value="1">天</Radio>
            <Radio value="2">周</Radio>
            <Radio value="3">月</Radio>
            <Radio value="4">年</Radio>
          </RadioGroup>
        </FormItem>
      );
      if (planType === '1') {
        htmlArray.push(
          <FormItem label={<span>执行间隔</span>} field="executeInterval" {...formItemLayout}>
            <InputNumber
              className="plan_info_input"
              value={form.executeInterval}
              min={1}
              placeholder="执行间隔"
              onChange={e => this.onSelectChange('executeInterval', e)}
            />
            <span className="ant-form-text">{form.tepmUnit}</span>
          </FormItem>
        );
        htmlArray.push(
          <FormItem label={<span>每天频率</span>} field="dayRate" {...formItemLayout}>
            <RadioGroup defaultValue={form.dayRate} value={form.dayRate} onChange={e => this.onSelectChange('dayRate', e)}>
              <Radio value={0}>一次</Radio>
              <Radio value={1}>多次</Radio>
            </RadioGroup>
          </FormItem>
        );
        htmlArray = this.getRateMenu(htmlArray, formItemLayout);
        htmlArray.push(
          <div>
            <FormItem label={<span>工作时长(分钟)</span>} field="duration" {...formItemLayout}>
              <InputNumber className="plan_info_input" value={form.duration} min={1} onChange={e => this.onSelectChange('duration', e)} />
            </FormItem>
            <FormItem label={<span>允许误差(分钟)</span>} field="error" {...formItemLayout}>
              <InputNumber
                className="plan_info_input"
                value={form.error}
                min={0}
                placeholder="请输入结束日期"
                onChange={e => this.onSelectChange('error', e)}
              />
            </FormItem>
          </div>
        );
      } else if (planType === '2') {
        htmlArray.push(
          <div>
            <FormItem label={<span>执行间隔</span>} field="executeInterval" {...formItemLayout}>
              <InputNumber
                className="plan_info_input"
                min={1}
                value={form.executeInterval}
                placeholder="执行间隔"
                onChange={e => this.executeChange('executeInterval', e)}
              />
              <span className="ant-form-text">{form.tepmUnit}</span>
            </FormItem>
            <FormItem label={<span>开始时间</span>} field="weekBeginNum" {...formItemLayout}>
              第:&nbsp;
              <Select
                data={dayData}
                renderOption={item => <Option value={item.id}>{item.id}</Option>}
                defaultValue={form.weekBeginNum}
                onChange={e => this.onSelectChange('weekBeginNum', e)}
              />
              天&nbsp;
              <Input className="plan_info_input" type="time" required value={form.dayBegin} onChange={e => this.onTimeChange('dayBegin', e)} />
            </FormItem>
            <FormItem label={<span>结束时间</span>} field="weekEndNum" {...formItemLayout}>
              第:&nbsp;
              <Select
                data={dayData}
                defaultValue={form.weekEndNum}
                renderOption={item => <Option value={item.id}>{item.id}</Option>}
                onChange={e => this.onSelectChange('weekEndNum', e)}
              />
              天&nbsp;
              <Input className="plan_info_input" type="time" required value={form.dayEnd} onChange={e => this.onTimeChange('dayEnd', e)} />
            </FormItem>
          </div>
        );
      } else if (planType === '3') {
        htmlArray.push(
          <FormItem label={<span>执行时间</span>} field="" {...formItemLayout}>
            <span className="plan-span-execute">本月1号00:00至下月1号00:00</span>
          </FormItem>
        );
      } else if (planType === '4') {
        htmlArray.push(
          <div>
            <FormItem label={<span>执行间隔</span>} field="executeInterval" {...formItemLayout}>
              <InputNumber
                className="plan_info_input"
                value={form.executeInterval}
                min={1}
                placeholder="执行间隔"
                onChange={e => this.onSelectChange('executeInterval', e)}
              />
              <span className="ant-form-text">{form.tepmUnit}</span>
            </FormItem>
            <FormItem label={<span>执行频率</span>} field="executeRate" {...formItemLayout}>
              <Select
                data={rateData}
                className="plan_task_gen_select"
                renderOption={item => <Option value={item}>{item}</Option>}
                defaultValue={form.executeRate}
                onChange={e => this.onSelectChange('executeRate', e)}
              />
              次
            </FormItem>
          </div>
        );
      }
    }

    return htmlArray;
  }

  handleSubmit = e => {
    this.form.validate((valid, dataValues) => {
      if (valid) {
        let param = {};
        let { form } = this.state;
        Object.assign(param, form);
        if (form.userId) {
          param.userId = form.userId.join(',');
        }
        if (form.planType === '2' && form.isFixedDate === '1') {
          param.whatDay = form.whatDayArr.join(',');
        }
        if (!form.planBegin) {
          param.planBegin = moment().format('YYYY-MM-DD');
        }
        createPlanAction(param).then(
          data => {
            AmosAlert.success('提示', '保存成功');
            browserHistory.goBack('/main/patrol/plan');
          },
          err => {
            AmosAlert.error('错误', err);
          }
        );
      } else {
        return false;
      }
    });
  };

  handleCancel = e => {
    browserHistory.goBack('/main/patrol/plan');
  };

  executeChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    let data = [];
    for (let i = 1; i <= value * 7; i++) {
      data.push({ id: i });
    }
    this.setState({ form, dayData: data });
  };

  queryRouteByOrgCode = () => {
    queryAllRouteAction().then(data => {
      let routeData = data;
      this.setState({ routeData });
    });
  };

  queryDeptByOrgCode = () => {
    queryDeptByOrgCodeAction1().then(data => {
      let deptData = data;
      this.setState({ deptData });
    });
  };

  queryUserByDept = deptId => {
    queryUserByDeptIdAction(deptId).then(data => {
      let userData = data;
      this.setState({ userData });
    });
  };

  initRemark =()=>{
    const { form } = this.state;
    form.remark = '每' + form.executeInterval + unitData[form.planType] + '的' + form.dayTime.substring(0,5) + '执行。' + '将从' + form.planBegin + '开始使用计划。';
    this.setState({ form });
  }

  renderEndTime() {
    const { form } = this.state;
    switch (form.planType) {
      case '1':
        return form.planEnd ?
          <DatePicker
            format="YYYY-MM-DD"
            value={moment(form.planEnd)}
            className="plan_task_gen_select"
            onChange={e => this.onDateChange('planEnd', e)}
          /> : <DatePicker
            format="YYYY-MM-DD"
            value={form.planEnd}
            className="plan_task_gen_select"
            onChange={e => this.onDateChange('planEnd', e)}
          />;
      case '2':
        return  form.planEnd ?
          <WeekPicker
            className="plan_task_gen_select"
            value={moment(form.planEnd)}
            onChange={e => this.onWeekDateChange('planEnd', e)}
          /> :  <WeekPicker
            className="plan_task_gen_select"
            value={form.planEnd}
            onChange={e => this.onWeekDateChange('planEnd', e)}
          />;
      case '3':
        return form.planEnd ?
          <MonthPicker
            className="plan_task_gen_select"
            value={moment(form.planEnd)}
            format="YYYY-MM"
            onChange={e => this.onMonthDateChange('planEnd', e)}
          /> : <MonthPicker
            className="plan_task_gen_select"
            format="YYYY-MM"
            value={form.planEnd}
            onChange={e => this.onMonthDateChange('planEnd', e)}
          />;
      case '4':
        return form.planEnd ?
          <YearPicker
            value={form.planEnd}
            allowClear
            onChange={e => this.onYearDateChange('planEnd', e)}
          /> : <YearPicker
            isEmpty
            value={form.planEnd}
            onChange={e => this.onYearDateChange('planEnd', e)}
          />;
    }
  }

  renderStartTime() {
    const { form } = this.state;
    switch (form.planType) {
      case '1':
        return  <DatePicker value={moment(form.planBegin)} allowClear={false} className="plan_task_gen_select" defaultValue={moment()} format="YYYY-MM-DD" onChange={e => this.onDateChange('planBegin', e)} />;
      case '2':
        return <WeekPicker value={moment(form.planBegin)} allowClear={false} className="plan_task_gen_select" onChange={e => this.onWeekDateChange('planBegin', e)} />;
      case '3':
        return <MonthPicker value={moment(form.planBegin)} format="YYYY-MM" className="plan_task_gen_select" allowClear={false} onChange={e => this.onMonthDateChange('planBegin', e)} />;
      case '4':
        return <YearPicker value={form.planBegin}  onChange={e => this.onYearDateChange('planBegin', e)} />;
    }
  }

  validPlanBegin =(rule, planBegin,callback)=>{
    const { form } = this.state;
    const planEnd = form.planEnd;
    if (planEnd) {
      moment(planBegin) > moment(planEnd) ? callback('开始日期不能大于结束日期') : callback();
    } else {
      callback();
    }
  }

  validPlanEnd =(rule, planEnd,callback)=>{
    const { form } = this.state;
    const planBegin = form.planBegin;
    if (planEnd) {
      moment(planEnd) < moment(planBegin) ? callback('结束日期不能小于开始日期') : callback();
    } else {
      callback();
    }
  }

  /**
   *
   *
   * @returns
   * @memberof PlanInput
   */
  render() {
    const { form, routeData, deptData, userData, rules } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 4 }
      }
    };

    return (
      <div className="plan_edit_div">
        <Form model={form} rules={rules} ref={component =>this.form = component}>
          <FormItem label={<span>计划名称</span>} field="name" {...formItemLayout}>
            <Input value={form.name} className="plan_info_input" maxLength = "50" onChange={e => this.onChange('name', e)} />
          </FormItem>
          <FormItem label={<span>是否计算评分</span>} field="isScore" {...formItemLayout}>
            <RadioGroup defaultValue={form.isScore} value={form.isScore} onChange={e => this.onSelectChange('isScore', e)}>
              <Radio value="1">是</Radio>
              <Radio value="0">否</Radio>
            </RadioGroup>
          </FormItem>
          {/* <FormItem label={<span>评分计算公式</span>} field="scoreFormula" {...formItemLayout}>
            <Input value={form.scoreFormula} className="plan_info_input" onChange={e => this.onChange('scoreFormula', e)} />
            <span className="ant-form-text">默认为空，按累加求和计算。</span>
          </FormItem> */}
          <FormItem label={<span>巡检路线</span>} field="routeId" {...formItemLayout}>
            <Select
              searchable
              className="plan_task_gen_select"
              data={routeData}
              renderOption={item => <Option value={item.id}>{item.name}</Option>}
              value={form.routeId}
              onChange={e => this.onSelectChange('routeId', e)}
            />
          </FormItem>
          <FormItem label={<span>执行方式</span>} field="isSingleExecution" {...formItemLayout}>
            <RadioGroup value={form.isSingleExecution ? '1' : '0'} onChange={e => this.onSelectChange('isSingleExecution', e === '1' ? true : false)}>
              <Radio value="1">单人执行</Radio>
              <Radio value="0">多人执行</Radio>
            </RadioGroup>
          </FormItem>
          <FormItem label={<span>按顺序巡检</span>} field="inOrder" {...formItemLayout}>
            <RadioGroup defaultValue={form.inOrder} value={form.inOrder} onChange={e => this.onSelectChange('inOrder', e)}>
              <Radio value="1">是</Radio>
              <Radio value="0">否</Radio>
            </RadioGroup>
          </FormItem>
          <FormItem label={<span>开始日期</span>} field="planBegin" {...formItemLayout}>
            {this.renderStartTime()}
          </FormItem>
          <FormItem label={<span>结束日期</span>} field="planEnd" {...formItemLayout}>
            {this.renderEndTime()}
            <span className="ant-form-text"> 为空时，永不结束</span>
          </FormItem>
          <FormItem label={<span>是否固定日期</span>} field="isFixedDate" {...formItemLayout}>
            <RadioGroup defaultValue={form.isFixedDate} value={form.isFixedDate} onChange={e => this.onSelectChange('isFixedDate', e)}>
              <Radio value="1">是</Radio>
              <Radio value="0">否</Radio>
            </RadioGroup>
          </FormItem>
          <div>{this.getMenuByisFixedDate(formItemLayout)}</div>
          <FormItem label={<span>执行部门</span>} field="deptId" {...formItemLayout}>
            <Select
              searchable
              className="plan_task_gen_select"
              data={deptData}
              renderOption={item => <Option value={item.sequenceNbr}>{item.departmentName}</Option>}
              defaultValue={<Option value=''>请选择</Option>}
              value={form.deptId}
              onChange={e => this.onDeptChange('deptId', e)}
            />
          </FormItem>
          <FormItem label={<span>执行人</span>} field="userId" {...formItemLayout}>
            <MultiSelect
              searchable
              className="plan_multi-select"
              data={userData}
              renderOption={item => <Option value={item.id}>{item.name}</Option>}
              //defaultOption={<Option>请选择</Option>}
              values={form.userId}
              onChange={e => this.onSelectChange('userId', e)}
            />
          </FormItem>
          <FormItem label={<span>执行说明</span>} field="remark" {...formItemLayout}>
            <TextArea className="plan_info_text_remark" rows={6} value={form.remark} disableResize disabled />
          </FormItem>
          <FormItem label={<span>备注</span>} field="remark1" {...formItemLayout}>
            <TextArea className="plan_info_text_area" rows={6} value={form.remark1} disableResize onChange={e => this.onChange('remark1', e)} />
          </FormItem>
          <FormItem {...wrapperCol}>
            <HasPermission permissionCode="plan">
              <Button onClick={this.handleSubmit}>提交</Button>
            </HasPermission>
            <Button onClick={this.handleCancel}>返回</Button>
          </FormItem>
        </Form>
      </div>
    );
  }
}

export default PlanInput;
