import AmosGridTable from '../../component/table/table/AmosGridTable';
import React, { Component } from 'react';
import { AmosAlert } from 'amos-framework';
import dt2react from 'dt2react';
import { browserHistory } from 'amos-react-router';
import PropTypes from 'prop-types';
import { pathMapping } from './../../../routes/customRoutes';
import ToolBar from './../../component/toolbar';
import { queryInputItemAction, batchDelInputItemAction, saveAsInputItemAction, saveAsPlanAction, batchDetPlanAction,endplanAction,startplanAction,btnAuthAction} from '../../../services/checkService';

const planInput = pathMapping.planInput;

const planInputxq = pathMapping.planInputxq;
const planTask = pathMapping.planTask;
const checkUrl = pathMapping.check;
const planStatusEnum = { 1: '日', 2: '周', 3: '月', 4: '年' };
const fixStatusEnum = { 0: '否', 1: '是' };

  const dropnavs1 ={ key: '1', text: '添加', icon: 'add', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: true };
  const dropnavs2 ={ key: '2', text: '修改', icon: 'edit', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: true };
  const dropnavs3 ={ key: '3', text: '另存', icon: 'save', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: true };
  const dropnavs4 ={ key: '4', text: '删除', icon: 'delete', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: true };
  const dropnavs5 ={ key: '5', text: '计划执行', icon: 'task', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: true };
  const dropnavs6 ={ key: '6', text: '巡检记录', icon: 'history', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: false };
  const dropnavs7 ={ key: '7', text: '停用计划', icon: 'history', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: true };
  const dropnavs8 ={ key: '8', text: '启用计划', icon: 'history', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: true };
  const dropnavs9 ={ key: '9', text: '明细', icon: 'edit', href: 'jacascript::void(0)', permissionCode: 'plan', isWriteable: true };

const getColumns = () => {
  return [
    {
      title: '计划编号',
      dataIndex: 'id',
      key: 'id',
      width: 100,
      className: 'uant-table-thead'
    },
    {
      title: '计划名称',
      dataIndex: 'name',
      key: 'name',
      width: 190,
      className: 'uant-table-thead'
    },
    {
      title: '计划类型',
      dataIndex: 'planType',
      key: 'planType',
      width: 100,
      render: text => planStatusEnum[text],
      className: 'uant-table-thead'
    },
    {
      title: '计划状态',
      dataIndex: 'status',
      key: 'status',
      width: 100,
      className: 'uant-table-thead'
    },
    {
      title: '巡检路线',
      dataIndex: 'routeName',
      key: 'routeName',
      width: 180,
      className: 'uant-table-thead'
    },
    {
      title: '是否固定日期',
      dataIndex: 'isFixedDate',
      key: 'isFixedDate',
      width: 100,
      render: text => fixStatusEnum[text],
      className: 'uant-table-thead'
    },
    {
      title: '执行说明',
      dataIndex: 'remark',
      key: 'remark',
      width: 480,
      className: 'uant-table-thead'
    },
    {
      title: '备注',
      dataIndex: 'remark1',
      key: 'remark1',
      width: 180,
      className: 'uant-table-thead'
    }
  ];
};

/**
 * 巡检项
 *
 * @class PlanTable
 * @extends {Component}
 */
class PlanTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 10
    };
    this.state = {
      pagination: true,
      isChecked: true,
      selectedRows: [],
      selectedRowKeys: [],
      data: [],
      dropnavs:[]
    };
  }

  /**
   * 组件初始化调用
   */
  componentWillMount = () => {
    this.reloadButtonAuth();

  };
  reloadButtonAuth = () => {
    // const _path = this.calcRoutes();
    btnAuthAction('/main/patrol/plan').then(data => {
      
      let { dropnavs } = this.state;
     if(data){
  
       if("tj" in data&&data.tj.hasPermission){
        dropnavs.push( dropnavs1);
       }
       if("xg" in data&&data.xg.hasPermission){
        dropnavs.push( dropnavs2);
  
      }
      if("lc" in data&&data.lc.hasPermission){
        dropnavs.push( dropnavs3);
  
      }
      if("sc" in data&&data.sc.hasPermission){
        dropnavs.push( dropnavs4);
  
      }
      if("jhzx" in data&&data.jhzx.hasPermission){
        dropnavs.push( dropnavs5);
  
      }
      if("xjjh" in data&&data.xjjh.hasPermission){
        dropnavs.push( dropnavs6);
  
      }
      if("tyjh" in data&&data.tyjh.hasPermission){
        dropnavs.push( dropnavs7);
  
      }
      if("qyjh" in data&&data.qyjh.hasPermission){
        dropnavs.push( dropnavs8);
  
      }
      if("mx" in data&&data.mx.hasPermission){
        dropnavs.push( dropnavs9);
  
      }
      
     }
  
      this.setState({ dropnavs});
    });
  }
  /**
   * 分页设置参数
   */
  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.pageNumber = current;
    }
  };

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  getRowClassName = (record, index) => {
    let highlight = this.highlight;
    if (highlight && record.id === highlight) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  clearSelectedRows = () => {
    this.setState({ selectedRows: [], selectedRowKeys: [] });
  };

  reloadPage = () => {
    this.clearSelectedRows();
    this.state.reload();
  };

  savaAs = () => {
    let { selectedRowKeys } = this.state;
    if (selectedRowKeys === undefined || selectedRowKeys.length <= 0) {
      AmosAlert.warning('提示', '请先点击选择需要另存的巡检计划');
      return;
    }
    let ids = selectedRowKeys;
    AmosAlert.confirm('提示', '确定要另存指定的巡检计划么?', {
      callback: flag => {
        if (flag) {
          // 确定另存
          saveAsPlanAction(ids).then(
            data => {
              AmosAlert.success('提示', '保存成功');
              this.reloadPage();
            },
            err => {
              AmosAlert.error('错误', err);
            }
          );
        }
      }
    });
  };

  deletePlan = () => {
    let { selectedRowKeys } = this.state;
    if (selectedRowKeys === undefined || selectedRowKeys.length <= 0) {
      AmosAlert.warning('提示', '请先点击选择需要删除的行');
      return;
    }
    let ids = selectedRowKeys;
    AmosAlert.confirm('提示', '确定要删除指定的数据么?', {
      callback: flag => {
        if (flag) {
          // 确定删除
          batchDetPlanAction(ids).then(
            data => {
              AmosAlert.success('提示', '删除成功');
              this.reloadPage();
            },
            err => {
              AmosAlert.error('错误', err);
            }
          );
        }
      }
    });
  };
  updatePlan = () => {
    const { selectedRows } = this.state;
    if (selectedRows === undefined || selectedRows.length <= 0) {
      AmosAlert.warning('提示', '请选择要修改的巡检计划');
      return;
    }
    if (selectedRows.length > 1) {
      AmosAlert.warning('提示', '至多选择一条要修改的巡检计划');
      return;
    }
    let row = selectedRows[0];
    let path = {
      pathname: planInput,
      state: { planId: row.id }
    };
    browserHistory.push(path);
  };

  updatePlanxq = () => {
    const { selectedRows } = this.state;
    if (selectedRows === undefined || selectedRows.length <= 0) {
      AmosAlert.warning('提示', '请选择巡检计划');
      return;
    }
    if (selectedRows.length > 1) {
      AmosAlert.warning('提示', '至多选择一条巡检计划');
      return;
    }
    let row = selectedRows[0];
    let path = {
      pathname: planInputxq,
      state: { planId: row.id }
    };
    browserHistory.push(path);
  };


  planGenForward = () => {
    const { selectedRows } = this.state;
    if (selectedRows === undefined || selectedRows.length <= 0) {
      AmosAlert.warning('提示', '请先点击选择需要查看的计划');
      return;
    }
    let row = selectedRows[0];
    let path = {
      pathname: planTask,
      state: { planId: row.id }
    };
    browserHistory.push(path);
  };

  checkInfoForward = () => {
    const { selectedRows } = this.state;
    if (selectedRows === undefined || selectedRows.length <= 0) {
      AmosAlert.warning('提示', '请先点击选择需要查看的计划');
      return;
    }
    let row = selectedRows[0];
    let path = {
      pathname: checkUrl,
      state: { planId: row.id }
    };
    browserHistory.push(path);
  };


  endplan = () => {
    let { selectedRowKeys ,selectedRows} = this.state;
    if (selectedRowKeys === undefined || selectedRowKeys.length <= 0) {
      AmosAlert.warning('提示', '请先点击选择巡检计划');
      return;
    }

    let a=0;
    selectedRows.forEach(element => {
    
    
      if(element.status==='停用'){
        a=a+1;
     
      }
     
    });
    if(a>0){
     
      AmosAlert.warning('提示', '请选择正常的计划巡检计划');
      return;
    }

    let ids = selectedRowKeys;
    AmosAlert.confirm('提示', '确定要停用计划吗?', {
      callback: flag => {
        if (flag) {
          // 确定删除
          endplanAction(ids).then(
            data => {
              AmosAlert.success('提示', '停止成功');
              this.reloadPage();
            },
            err => {
              AmosAlert.error('错误', err);
            }
          );
        }
      }
    });
  };


  startplan = () => {
    let { selectedRowKeys,selectedRows } = this.state;
    if (selectedRows === undefined || selectedRows.length <= 0) {
      AmosAlert.warning('提示', '请先点击选择巡检计划');
      return;
    }

    if (selectedRows.length > 1) {
      AmosAlert.warning('提示', '至多选择一条要修改的巡检计划');
      return;
    }
    let row = selectedRows[0];
    
    if(row.status==='正常'){
      AmosAlert.warning('提示', '请选择停用的计划巡检计划');
      return;
    }




    let ids = selectedRowKeys;
    AmosAlert.confirm('提示', '确定要启用巡检计划吗?', {
      callback: flag => {
        if (flag) {
          // 确定删除
          startplanAction(ids).then(
            data => {
              AmosAlert.success('提示', '已启用');
              this.reloadPage();
            },
            err => {
              AmosAlert.error('错误', err);
            }
          );
        }
      }
    });
  };












  onClickBootBar = type => {
    if (type === '1') {
      browserHistory.push(planInput);
    } else if (type === '2') {
      this.updatePlan();
    } else if (type === '3') {
      this.savaAs();
    } else if (type === '4') {
      this.deletePlan();
    } else if (type === '5') {
      this.planGenForward();
    } else if (type === '6') {
      this.checkInfoForward();
    }else if (type === '7') {
      this.endplan();
    }else if (type === '8') {
      this.startplan();
    }else if (type === '9') {
      this.updatePlanxq();
    }
  };

  onRowDoubleClick = (record, index, event) => {
    let path = {
      pathname: planInput,
      state: { planId: record.id }
    };
    browserHistory.push(path);
  };

  render() {
    let { pagination, isChecked, selectedRowKeys,dropnavs } = this.state;
    let { dataList, fetchData, count } = this.props;
    let defaultPageConfig = this.pageConfig;
    return (
      <div className="patrol-page-table">
        <ToolBar dropnavs={dropnavs} callBack={this.onClickBootBar} />
        <AmosGridTable
          rowKey="id"
          columns={getColumns()}
          callBack={this.reload}
          isPageable={pagination}
          dataList={dataList}
          totals={count}
          selectedRowKeys = {selectedRowKeys}
          getTableDataAction={fetchData}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          onRowDoubleClick={this.onRowDoubleClick}
          isChecked={isChecked}
        />
      </div>
    );
  }
}

PlanTable.propTypes = {
  queryParam: PropTypes.object
};

export default PlanTable;
