import React, { Component } from 'react';
import PropTypes from 'prop-types';
import PlanSearch from './PlanSearch';
import PlanTable from './PlanTable';
import { queryPlanInfoAction } from '../../../services/checkService';
import SplitterLayout from '../../component/SplitLayout';

/**
 * 巡检计划
 *
 * @class Plan
 * @extends {Component}
 */
class Plan extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      statisticsData: [],
      totalCount: 0
    };
  }

  questStatistiscData = param => {
    let { searchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    this.queryPlanInfo(searchParam, pageNumber, pageSize);
  };

  onSearchDataSyn = (queryParam, param) => {
    let { searchParam } = this.state;
    let request = [];
    if (queryParam) {
      for (let key in queryParam) {
        let obj = queryParam[key];
        request.push(obj);
      }
    }
    this.setState({ searchParam: request });
    setTimeout(() => {
      this.questStatistiscData(param);
    }, 0);
   
   
  };

  queryPlanInfo = (searchParam, pageNumber, pageSize) => {
    queryPlanInfoAction(searchParam, pageNumber, pageSize).then(data => {
      let statisticsData = data.content;
      let totalCount = data.totalElements;
      this.setState({
        statisticsData,
        totalCount
      });
    });
  };

  render() {
    let { statisticsData, totalCount } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <PlanSearch search={this.onSearchDataSyn} />
        </SplitterLayout>
        <PlanTable count={totalCount} fetchData={this.questStatistiscData} dataList={statisticsData} />
      </div>
    );
  }
}

Plan.propTypes = {};

export default Plan;
