import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
import PlanTaskTable from './PlanTaskTable';
import PlanTaskSearch from './PlanTaskSearch';
import { queryPlanTaskInfoAction } from '../../../../services/checkService';
import SplitterLayout from '../../../component/SplitLayout';

/**
 * 巡检计划执行
 *
 * @class Plan
 * @extends {Component}
 */
class PlanTask extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [
        { name: 'beginDate',value: moment().startOf('day').format('YYYY-MM-DD HH:mm:ss') },
        { name: 'endDate',value: moment().endOf('day').format('YYYY-MM-DD HH:mm:ss') }
      ],
      statisticsData: [],
      totalCount: 0,
      planId: ''
    };
  }
  componentWillMount = () => {
    const { planId } = (this.props.location || {}).state || {};
    let { searchParam } = this.state;
    if (planId) {
      searchParam.push({ name: 'planId', value: planId });
      this.setState({ searchParam, planId });
    }
  };

  onSearchDataSyn = (queryParam, param) => {
    let quest = [];
    if (queryParam) {
      for (let key in queryParam) {
        let obj = queryParam[key];
        quest.push(obj);
      }
    }
    this.setState({ searchParam: quest }, () => {
      this.questStatistiscData(param);
    });
  };

  questStatistiscData = param => {
    let { searchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    this.queryPlanTaskInfo(searchParam, pageNumber, pageSize);
  };

  queryPlanTaskInfo(searchParam, pageNumber, pageSize) {
    queryPlanTaskInfoAction(searchParam, pageNumber, pageSize).then(data => {
      let statisticsData = data.content;
      let totalCount = data.totalElements;
      this.setState({
        statisticsData,
        totalCount
      });
    });
  }

  render() {
    let { statisticsData, totalCount, planId, searchParam } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <PlanTaskSearch search={this.onSearchDataSyn} planId={planId} />
        </SplitterLayout>
        <PlanTaskTable count={totalCount} searchParam={searchParam} fetchData={this.questStatistiscData} dataList={statisticsData} planId={planId} />
      </div>
    );
  }
}

PlanTask.propTypes = {
  location: PropTypes.object
};

export default PlanTask;
