import React, { Component } from 'react';
import { MultiSelect } from 'amos-framework';
import PropTypes from 'prop-types';

const MultiOption = MultiSelect.Option;

class MyMultiSelect extends Component {

  componentWillMount = () => {
    this.setState({
      inputItemData: this.props.inputItemData,
      record: this.props.record,
      catalogWithInputItem: this.props.catalogWithInputItem
    });
    this.onInputItemSelectChange = this.onInputItemSelectChange.bind(this);
  };

  onInputItemSelectChange(keys) {
    let { inputItemData, record, catalogWithInputItem } = this.state;
    let tempInputItemName = [];
    let tempInputItemId = [];

    if (record.name === undefined || catalogWithInputItem === undefined) {
      return;
    }
    catalogWithInputItem[record.name +   '*' + record.orderNo] = {};

    for (let itemId of keys) {
      for (let inputItem of inputItemData) {
        if (inputItem.id === itemId) {
          tempInputItemName.push(inputItem.name);
          tempInputItemId.push(inputItem.id);

          catalogWithInputItem[record.name + '*' + record.orderNo].name = record.name;
          catalogWithInputItem[record.name + '*' + record.orderNo].orderNo = record.orderNo;
          catalogWithInputItem[record.name + '*' + record.orderNo].pointId = record.pointId;
          if (void 0 === catalogWithInputItem[record.name + '*' + record.orderNo].pointInputItemVo) {
            catalogWithInputItem[record.name + '*' + record.orderNo].pointInputItemVo = new Array();
          }
          catalogWithInputItem[record.name + '*' + record.orderNo].pointInputItemVo.push(inputItem);
        }
      }
    }
    record.inputItemId = tempInputItemId;
    record.inputItemName = tempInputItemName.join();

    this.setState({ catalogWithInputItem });
    this.props.onMultiSelectChange(record);
  }

  getSelectInputItemId() {
    let { record, catalogWithInputItem } = this.state;
    if (catalogWithInputItem !== undefined) {
      
      for (let name of Object.keys(catalogWithInputItem)) {
        if (name === (record.name +  '*' + record.orderNo)) {
          let tempItemIdData = [];         
          if(Object.keys(catalogWithInputItem[name]).length){
            for (let i = 0; i < catalogWithInputItem[name].pointInputItemVo.length; i++) {
              tempItemIdData.push(catalogWithInputItem[name].pointInputItemVo[i].id);
            }
          }
          return tempItemIdData;
        }
      }
    }
  }

  render() {
    let { inputItemData } = this.state;

    return (
      <MultiSelect
        data={inputItemData}
        className="point-catalog-add-select"
       renderOption={item => <MultiOption value={item.id}>{(item.itemNo == "" ? '' : "["+item.itemNo+"]")+item.name }</MultiOption>}
        onChange={this.onInputItemSelectChange}
        values={this.getSelectInputItemId()}
      />
    );
  }
}

MyMultiSelect.propTypes = {
  inputItemData: PropTypes.array,
  record: PropTypes.any,
  onMultiSelectChange: PropTypes.func,
  catalogWithInputItem: PropTypes.array
};

export default MyMultiSelect;
