import React, { Component } from 'react';
import { SplitPane, Input } from 'amos-framework';
import PropTypes from 'prop-types';
import CommonTablexq from '../inputItem/CommonTablexq';
import MyMultiSelect from './MyMultiSelect';

const LevelEnum = { '1': '1级', '2': '2级', '3': '3级', '4': '4级', '5': '5级' };

/**
 * 巡检点分类信息
 *
 * @class PointCatalogInfo
 * @extends {Component}
 */
class PointCatalogInfoxq extends Component {
  constructor(props) {
    super(props);
    this.state = {
      inputItemData: [],
      tableData: [],
      catalogWithInputItem: []
    };
    this.onMultiSelectChange = this.onMultiSelectChange.bind(this);
  }

  /**
   * 组件初始化调用
   */
  componentWillMount = () => {
    let _inputItemData = this.processInputItemData();
    this.setState({
      inputItemData: _inputItemData,
      tableData: this.props.catalogInputItemData,
      catalogWithInputItem: this.props.catalogWithInputItem
    });

  };

  componentWillReceiveProps = (nextProps) => {
    let _inputItemData = this.processInputItemData();
    this.setState({
      inputItemData: _inputItemData
    });
  }

  onCatalogTableValueChange(record, e) {
    const { tableData } = this.state;
    for (let i = 0; i < tableData.length; i++) {
      if ( tableData[i].orderNo === record.orderNo ) {
        tableData[i].name = e;
      }
    }
    this.setState(tableData);
  }

  onMultiSelectChange(record) {
    let { tableData } = this.state;
    for (let i in tableData) {
      if (tableData[i].orderNo === record.orderNo) {
        tableData[i] = record;
      }
    }
    console.log('onMultiSelectChange-------');
  }

  onChangeTableValues = (data) => {

    this.props.onCatalogTableValueChange(data);
    this.setState({ tableData: data });
  }

  getPointCatalogColumns = () => {
    let { inputItemData, catalogWithInputItem } = this.state;
    // TODO catalogWithInputItem -> MyMultiSelect需要的格式
    return [
      {
        title: '分类名称',
        dataIndex: 'name',
        key: 'name',
        width: '40%',
        render: (text, record) => {
          return !record.edit ? text : <Input onChange={e => this.onCatalogTableValueChange(record, e.target.value)} value={text} className='point-catalog-add-input' />;
        }
      },
      {
        title: '巡检项',
        dataIndex: 'inputItemName',
        key: 'inputItemName',
        width: '60%',
        render: (text, record) => {
          return !record.edit ? text ? text : '' :
          <MyMultiSelect onMultiSelectChange={this.onMultiSelectChange} record={record} inputItemData={inputItemData} catalogWithInputItem={catalogWithInputItem} />;
        }
      }
    ];
  }

  processInputItemData() {
    let _inputItemData = [];
    this.props.pointInputItemData.forEach(item => {
    if(item.id != 0){
      let obj = Object.assign({}, item);
      let level = LevelEnum[obj.level];
      level = level ? '(' + level + ')' : '';
      obj.name = obj.name + level;
      _inputItemData.push(obj);
  }
    });
    return _inputItemData;
  }

  processCatalogWithInputItem() {

  }

  render() {
    let { tableData } = this.state;
    let { edit } = this.props;
    let addHide = false;
    let percentage = true;
    let hidden = edit ? edit : false;
    return (
      <div className="point-catalog">
        <div className="point-catalog-title" hidden={hidden}>
          <span>扩展分类</span>
        </div>
        <SplitPane vertical mainPaneIndex={1} secondaryDefaultSize={90} percentage={percentage}>
          <div className="point-catalog-table">
            <CommonTablexq
              tableData={tableData}
              onChangeTableValues={this.onChangeTableValues}
              addHide={addHide}
              columns={this.getPointCatalogColumns()}
              scroll={{ x: true, y: 150 }}
            />
          </div>
        </SplitPane>
      </div>
    );
  }
}

PointCatalogInfoxq.propTypes = {
  onCatalogTableValueChange: PropTypes.func,
  tableData: PropTypes.array,
  pointInputItemData: PropTypes.array,
  catalogWithInputItem: PropTypes.array,
  edit: PropTypes.bool,
  catalogInputItemData: PropTypes.array
};

export default PointCatalogInfoxq;
