import React, { Component } from 'react';
import PointTable from './PointTable';
import SplitterLayout from '../../component/SplitLayout';
import PointSearch from './PointSearch';

/**
 * 业务视图
 *
 * @class PointView
 * @extends {Component}
 */
class PointView extends Component {
  constructor(props) {
    super(props);

    this.state = {
      operationType: '',
      queryParam: {}
    };
  }

  queryTableData = (requestParam, pageParam) => {
    this.setState({ operationType: 'query', queryParam: requestParam });
  };

  render() {
    let { operationType, queryParam } = this.state;

    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <PointSearch search={this.queryTableData} />
        </SplitterLayout>
        <PointTable operationType={operationType} queryParam={queryParam} />
      </div>
    );
  }
}

PointView.propTypes = {};

export default PointView;
