import React, { Component } from 'react';
import _amosTool from 'amos-tool';
import SysConsts from 'amos-processor/lib/config/consts';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { TreeSelect } from 'amos-antd';
import { Form, Button,  Upload, message } from 'amos-framework';
import Icon from 'amos-icon';
import { browserHistory } from 'amos-react-router';
import { patrolUrls } from './../../../consts/urlConsts';

const getHeaders = () => {
  return {
    'Accept': 'application/json;charset=UTF-8',
    'Content-Type': 'application/json; charset=utf-8',
    'X-Api-Key': _amosTool.Store.getCookieByName(apiKey),
    'X-Access-Token': ls.read(token),
    'token': ls.read(token),
    'appKey': 'YH-PATROL',
    'product': 'YH-PATROL_WEB'
  }
}

const ls = _amosTool.Store.lsTool;
const apiKey = SysConsts.api_key;
const token = SysConsts.token;
const FormItem = Form.Item;

class ImportPoint extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }

  handleCancel = e => {
    browserHistory.goBack('/main/patrol/point');
  };


  handleExport = e => {
    let url = formatUrl(patrolUrls.exportPointTemplateUrl);
    fetch(url, {
      method: 'post',
      headers: getHeaders(),
    }).then((e) => {
      if (e.status === 200) {
        e.blob().then((blob) => {
          const a = window.document.createElement('a');
          const downUrl = window.URL.createObjectURL(blob);
          const filename = ['巡检点', 'xls'];
          a.href = downUrl;
          a.download = `${decodeURI(filename[0])}.${filename[1]}`;
          a.click();
          window.URL.revokeObjectURL(downUrl);
        });
      } else {
        _amosTool.Log.error(e.message);
      }
    }).catch((e) => {
      _amosTool.Log.error(e.message);
    });
  }

  render() {
    let _false_ = false;
    const props = {
      name: 'file',
      action: patrolUrls.importPointUrl,
      showUploadList: { _false_ },
      headers: {
        'Accept': 'application/json;charset=UTF-8',
        'X-Api-Key': _amosTool.Store.getCookieByName(apiKey),
        'X-Access-Token': ls.read(token),
        'token': ls.read(token),
        'appKey': 'YH-PATROL',
        'product': 'YH-PATROL_WEB'
      },
      onChange(info) {
        if (info.file.status !== 'uploading') {
          console.log(info.file, info.fileList);
        }
        if (info.file.status === 'done') {
          message.success(`${info.file.name} 上传成功`);
        } else if (info.file.status === 'error') {
          message.danger(`${info.file.name} 失败.`);
        }
      }
    };

    let p = `[{"Name":"额定电压","Value":"200V","Url":""},{"Name":"技术文档","Value":"操作手册","Url":"http://www.yeejoin.com"}]`;
    let marginLeft = {marginLeft: '10px'};
    return (
      <div className="plan_edit_div">
        <Form>
          <FormItem>
            <div>
              <strong><span></span>从Excel文件批量导入巡检点</strong>
              <p>1、请先下载巡检点批量导入模板，按文件格式要求填写内容，然后上传文件，批量导入数据。</p>
              <p>2、请不要将模版文件另存为xlsx格式，必须是xls格式。</p>
              <p>3、请不要删除模版文件中的任何列和表头行，也不要修改列标题和顺序，红色标题的是必填列。</p>
              <p>4、检查项目、巡检路线允许填写多个，之间使用<font color="red">英文半角</font>的逗号分隔(例如：项目1,项目2,项目3)，并且必须是系统中已存在的，不能匹配的将被忽略。</p>
              <p>5、如果巡检点已存在，系统会忽略跳过，不会覆盖。</p>
              <br />
            </div>
          </FormItem>
          <FormItem>
            <Button onClick={this.handleExport}>导出模板</Button>
            <Button onClick={this.handleCancel}>返回</Button>
            <Upload {...props} style={marginLeft}>
              <Button>
                <Icon type="upload" />确定导入
              </Button>
            </Upload>
          </FormItem>
        </Form>
      </div>
    );
  }
}

export default ImportPoint;
