import React, { Component } from 'react';
import InputItemSearch from './routeSearch';
import InputItemTable from './routeTable';
import SplitterLayout from '../../component/SplitLayout';

/**
 * 巡检项
 *
 * @class Route
 * @extends {Component}
 */
class Route extends Component{
  state = {
    changeType: '',
    queryParam: {}
  }

  queryTableData = (requestParam) =>{
    this.setState({ changeType: 'query', queryParam: requestParam });
  }

  render() {
    const { changeType, queryParam } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <InputItemSearch rearch={this.queryTableData} />
        </SplitterLayout>
        <InputItemTable  changeType={changeType} queryParam={queryParam}  />
      </div>
    );
  }
}

Route.propTypes = {};

export default Route;
