import React, { Component } from 'react';
import { SplitPane, Collapse } from 'amos-framework';
import PropTypes from 'prop-types';
import BootBar from '../../component/toolbar';
import RoutePointSearch from './routePointSearch';
import RoutePointTable from './routePointTable';
import PointInputItem from './inputeItem';
import '../../../styles/view/patrol/pointInputItem.scss';


const Panel = Collapse.Panel;

// const getDropnavs = () => {
//   return [
//     { key: '1', text: '返回', icon: 'fanhui', href: 'jacascript::void(0)' },
//     { key: '2', text: '添加', icon: 'edit' , href: 'jacascript::void(0)' },
//     { key: '3', text: '删除', icon: 'delete', href: 'jacascript::void(0)' },
//     { key: '4', text: '迁移', icon: 'ccgl-chukucaozuo-13' , href: 'jacascript::void(0)' }
//   ];
// }
/**
 * 巡检路线点
 *
 * @class RoutePoint
 * @extends {Component}
 */
class RoutePoint extends Component{
  constructor(props) {
    super(props);
    this.state = {
      routeId: '',
      changeType: 'query',
      queryParam: {}
    };
  }
  /**
   * 组件初始化时调用
   */
  componentWillMount = () => {
    const { routeId } = ((this.props.location || {} ).state) || {};
    routeId && this.setState({ routeId });
  }

  onClickBootBar = (type) => {
    this.setState({ changeType: type, pointId: '' });
  }

  queryTableData = (requestParam) =>{
    this.setState({ changeType: 'query', queryParam: requestParam, pointId: '' });
  }

  rowClick = (record, index) => {
    this.setState({ pointId: record.id });
  }

  render() {
    const { changeType, queryParam, routeId, pointId } = this.state;
    let def = true;
    return (
      <div className='route-point'>
        <SplitPane percentage={def}  mainPaneMinSize={80} secondaryMinSize={20}>
          <div className='patrol-page-content'>

            <RoutePointTable onRowDoubleClick={(record, index) => this.rowClick(record, index)} changeType={changeType} queryParam={queryParam} routeId={routeId} />
          </div>
          <div className='route-point-right'>
            <Collapse arrowAlign="right" activeKey={['1','2']}>
              <Panel header="查询" key="1">
                <RoutePointSearch rearch={this.queryTableData} />
              </Panel>
              <Panel header="巡检项"  key="2">
                <PointInputItem pointId={pointId} routeId={routeId} />
              </Panel>
            </Collapse>
          </div>
        </SplitPane>
      </div>
    );
  }
}

RoutePoint.propTypes = {
  location: PropTypes.object
};

export default RoutePoint;
