import React, { Component } from 'react';
import { Form, Input, Button } from 'amos-framework';

import PropTypes from 'prop-types';
import  './../../../styles/view/patrol/inputItem.scss';

const FormItem = Form.Item;

/**
 * 巡检项
 *
 * @class InputItemSearch
 * @extends {Component}
 */
class RoutePointSearch extends Component{
  constructor(props) {
    super(props);
    this.state = {
      form: {
        pointNo: '',
        name: ''
      }
    };
  }
  onChange = (key, e) => {
    let { form } = this.state;
    form[key] = e.target.value;
    this.setState({ form });
  }
  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key] = value;
    this.setState({ form });
  }
  handleSubmit = (e) => {
    const { form } = this.state;
    this.props.rearch(form);
  }
  render() {
    const { form } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo"  model={form} >
        <FormItem label={<span>点编号</span>} field="pointNo" {...formItemLayout} >
          <Input value={form.pointNo} prefixCls="" className="search_Input" onChange={(e) => this.onChange('pointNo', e)} />
        </FormItem>
        <FormItem label="点名称" field="name" {...formItemLayout} >
          <Input prefixCls="" className="search_Input" value={form.name} onChange={(e) => this.onChange('name', e)} />
        </FormItem>
        <FormItem  className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>查询</Button>
        </FormItem>
      </Form>
    );
  }
}

RoutePointSearch.propTypes = {
  rearch: PropTypes.func
};

export default RoutePointSearch;
