import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosAlert } from 'amos-framework';
import { browserHistory } from 'amos-react-router';
import RouteMain from './RouteMain';
import RoutePointTable from './routePoint/RoutePointTable';
import { saveRouteAction, updateRouteAction } from '../../../services/checkService';
import BootBar from '../../component/toolbar';
import { Dropdown, Button, DropNav, Icon, Menu } from 'amos-framework';
const dropnavs = [
    { key: '1', text: '返回', icon: 'fanhui', href: 'jacascript::void(0)' },
    { key: '2',  text: '提交', icon: 'edit' , href: 'jacascript::void(0)', permissionCode: 'route', isWriteable: true }
];

/**
 * 路线编辑及新增页面
 * @class RouteInfo
 * @extends {Component}
*/
class RouteInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      route: {},
      deptData: [],
      userData: [],
      dataList: [],
      routeId: ''
    };
  }

  componentWillMount =()=>{
    const { routeId, forword } = (this.props.location || {} ).state || {};
    routeId && this.setState({ routeId });
    forword && this.setState({ forword });
  }


  onClickBootBar = (type) => {
    if (type === '1') {
      browserHistory.goBack();
    } else if (type === '2') {
      this.saveRoute();
    }
  };



  setRoutePoint =(dataList)=>{
    this.setState({ dataList });
  }

  saveRoute = () => {
    this.routeMain.form.validate((valid, dataValues) => {
      if (valid) {
        const { form } = this.routeMain.state;
        const { data, deleteRowData } = this.routePoint.state;
        const { forword } = this.state;
        let requestBody = {};
        requestBody = Object.assign({},form);
        console.log(requestBody,'提交保存')
        requestBody.routePointList = [...data, ...deleteRowData];
        if (forword === 'edit'){
          updateRouteAction(requestBody).then(
            data => {
              AmosAlert.success('提示', '保存成功', {
                callback: () => {
                  browserHistory.goBack('/main/patrol/route');
                }
              });
            },
            error => {
              AmosAlert.error('错误', error);
            }
          );
        } else {
          saveRouteAction(requestBody).then(
            data => {
              AmosAlert.success('提示', '保存成功', {
                callback: () => {
                  browserHistory.goBack('/main/patrol/route');
                }
              });
            },
            error => {
              AmosAlert.error('错误', error);
            }
          );
        }

      } else {
        return false;
      }
    });
  };

  render() {
    const { routeId, forword } = this.state;
    return (
      <div className='route-info'>
        {/* <BootBar dropnavs={dropnavs} callBack={this.onClickBootBar} /> */}
        <Button onClick={() =>{this.onClickBootBar('1')} } transparent value='1' icon={'fanhui'} >返回</Button>
        <Button onClick={() =>{this.onClickBootBar('2')} } transparent value='2' icon={'edit'} >提交</Button>
        <RouteMain routeId={routeId}  ref={component => this.routeMain = component} />
        <RoutePointTable  routeId={routeId} forword={forword} ref={component =>this.routePoint = component} />
      </div>
    );
  }
}

RouteInfo.propTypes = {
  location: PropTypes.object
};

export default RouteInfo;
